---
title: Map
localeTitle: карта
---
## Введение карты

`map` - ассоциативный контейнер, который хранит элементы в паре ключ-значение. Так же, как в `Java` есть коллекция, ассоциативный массив в PHP и так далее.

## Преимущества использования карты

*   В нем хранятся только уникальные ключи, и это тоже упорядочено в соответствии с его назначенными критериями сортировки.
*   Поскольку ключи находятся в отсортированном порядке, поэтому поиск элемента на карте через ключ очень быстрый, т.е. он берет логарифмическое время.
*   На `map` будет только одно значение, прикрепленное к каждому ключу.
*   `map` может использоваться как ассоциативные массивы.
*   Он может быть реализован с использованием сбалансированных двоичных деревьев.

Вот пример:

```c++
#include <iostream> 
 #include <map> 
 
 using namespace std; 
 
 int main (){ 
  map<char,int> first; 
 
  //initializing 
  first['a']=10; 
  first['b']=20; 
  first['c']=30; 
  first['d']=40; 
 
   map<char, int>::iterator it; 
   for(it=first.begin(); it!=first.end(); ++it){ 
      cout << it->first << " => " << it->second << '\n'; 
   } 
 
  return 0; 
 } 
```

Вывод:
```
a => 10 
 b => 20 
 c => 30 
 d => 40 
```

## Создание объекта карты

`map<string, int> myMap;`

## вставка

Вставка данных с функцией вставки.

```c++
myMap.insert(make_pair("earth", 1)); 
 myMap.insert(make_pair("moon", 2)); 
```

Мы также можем вставлять данные в std :: map, используя оператор \[\], т.е.

`myMap["sun"] = 3;`

## Доступ к элементам карты

Чтобы получить доступ к элементам карты, вам необходимо создать для нее итератор. Вот пример, как было сказано ранее.

```c++
map<char, int>::iterator it; 
 for(it=first.begin(); it!=first.end(); ++it){ 
  cout << it->first << " => " << it->second << '\n'; 
 } 
```

Здесь вы можете узнать больше о карте: [cpluspluc\_map](http://www.cplusplus.com/reference/map/map/map/)

NB: весь код в примере приведен в версии C ++ 11. Вы можете узнать больше о версии C ++ [здесь](http://en.cppreference.com/w/cpp/compiler_support)