---
title: Object Oriented Programming using C++
localeTitle: Объектно-ориентированное программирование с использованием C ++
---
## Объектно-ориентированное программирование с использованием C ++

Объектно-ориентированное программирование, короткое ООП, предназначено для реализации объектов реального мира, таких как наследование, скрытие и полиморфизм в программировании. Основная цель ООП заключается в объединении данных и функций, которые работают на них, чтобы никакая другая часть кода не могла получить доступ к этим данным, кроме этой функции.

Давайте узнаем о разных характеристиках объектно-ориентированного языка программирования:

### Объект:

Объекты - это базовые объекты времени выполнения в объектно-ориентированной системе, объекты - это экземпляры класса, это определенные пользователем типы данных.

```cpp
class person 
 { 
    char name[20]; 
    int id; 
 public: 
    void getdetails(){} 
 }; 
 
 int main() 
 { 
   person p1; //p1 is an object 
 } 
```

Объекты занимают пространство в памяти и имеют ассоциированный адрес, такой как запись в паскале или структура или объединение в C.

Когда программа выполняется, объекты взаимодействуют, отправляя сообщения друг другу.

Каждый объект содержит данные и код для управления данными. Объекты могут взаимодействовать, не зная деталей данных или кода друг друга. Достаточно знать тип принятого сообщения и тип ответа, возвращаемого объектами.

### Учебный класс:

Класс - это план данных и функций или методов. Класс не занимает никакого места.

```cpp
class class_name 
 { 
  private: 
     //data members and member functions declarations 
  public: 
     //data members and member functions declarations 
  protected: 
     //data members and member functions declarations 
 }; 
```

Класс - это определенный пользователем тип данных, такой как структуры и объединения в C.

По умолчанию переменные класса являются частными, но в случае структуры они общедоступны. в приведенном выше примере человек - это класс.

### Инкапсуляция и абстракция данных:

Объединение (объединение) данных и функций в единый блок называется инкапсуляцией. Данные не доступны для внешнего мира, и к ним могут обращаться только те функции, которые обертываются в классе. Эта изоляция данных от прямого доступа к программе называется скрытием данных или скрытием информации.

Абстракция данных означает предоставление только необходимой информации внешнему миру и скрытие деталей реализации. Например, рассмотрим класс Complex с публичными функциями как getReal () и getImag (). Мы можем реализовать класс как массив размером 2 или как две переменные. Преимущество абстракций заключается в том, что мы можем изменить реализацию в любой момент, пользователи класса Complex не будут затронуты, так как наш интерфейс метода остается таким же. Если бы наша реализация была публичной, мы бы не смогли ее изменить.

### Наследование:

Наследование - это процесс, посредством которого объекты одного класса приобретают свойства объектов другого класса. Он поддерживает концепцию иерархической классификации. Наследование обеспечивает повторное использование. Это означает, что мы можем добавить дополнительные функции к существующему классу, не изменяя его.

### Полиморфизм:

Полиморфизм означает способность принимать более одной формы. В разных случаях операция может демонстрировать разные типы поведения. Поведение зависит от типов данных, используемых в операции.

C ++ поддерживает перегрузку и перегрузку функций. Перегрузка оператора - это процесс, при котором оператор может проявлять разные типы поведения в разных случаях. Перегрузка функций использует одно имя функции для выполнения различных задач. Полиморфизм широко используется при реализации наследования.

### Динамическое связывание:

В динамическом связывании код, который будет выполняться в ответ на вызов функции, определяется во время выполнения. У C ++ есть виртуальные функции для поддержки этого.

### Сообщение:

Объекты обмениваются данными друг с другом, отправляя и получая информацию друг другу. Сообщение для объекта - это запрос на выполнение процедуры и, следовательно, вызовет функцию в принимающем объекте, которая генерирует желаемые результаты. Передача сообщения включает указание имени объекта, имени функции и информации для отправки.