---
title: Random Functions
localeTitle: Случайные функции
---
*   Случайные числа - это удобный способ введения рандомизации в вашу программу. Например, если вы хотите запускать какие-либо симуляции или играть в игры, удаляйте случайные индексы массива и т. Д., Тогда случайные числа - это путь.
*   Файл заголовка для включения случайных чисел в c ++ - `cstdlib` .
*   _Pro tip: -_ Вы можете использовать `cpp #include<bits/stdc++.h>` чтобы включить все функции из всех файлов заголовков.

Функция: - rand ()  
\- Возвращает псевдослучайное число (целое число) от 0 до RAND _MAX. Не принимает никаких аргументов. - RAND_ MAX - максимально допустимое целое число. Это компилятор depedent и обычно составляет 2147483647.

Ниже приведен пример: -

```cpp
#include <cstdlib> 
 #include <iostream> 
 using namespace std; 
 
 int main() { 
  cout << rand() << endl; 
  cout << rand() << endl; 
  cout << rand() << endl; 
  return 0; 
 } 
 
 /* 
 Output:- (Note that the output is random and will differ from what is mentioned here) 
 1804289383 
 846930886 
 1681692777 
 */ 
```

Теперь запустите программу еще раз. И опять. И опять. Что ты видишь? Тот же вывод печатается снова и снова.

Давайте вернемся к определению функции rand (): -

rand (): - _возвращает **псевдослучайное** число (целое число) от 0 до RAND\_MAX. Не принимает никаких аргументов._

Итак, что такое псевдослучайное число?

*   Как следует из названия, число, которое не является действительно случайным, является псевдослучайным.
*   Псевдоэкспертные номера arent криптографически безопасны и уязвимы для атак.
*   В контексте C ++ число кажется случайным, но не по-настоящему случайным. Функция предполагает, что каждое число от 0 до RAND\_MAX одинаково вероятно и выплескивает одно число. (В действительности, это не тот случай, но он близок). Например, число 5 используется почти везде. Если случайное число плюет 5, вы можете не думать, что число является интактным, случайным.
*   Случайное funtion rand () принимает очень большое число, применяется по модулю большим простым числом и выполняет все виды операций над числом и возвращает значение. Как бы он ни был сложным, его все еще можно сломать.

Как мы получаем уникальный набор случайных чисел, выполняемых при выполнении каждой программы?

Мы используем `void srand(int seed)` ;

*   «Семя» - это имя, присвоенное числу, которое запускает генератор случайных последовательностей каждый раз в другой отправной точке. Это гарантирует, что случайная функция не выплевывает одинаковые значения во время прогона программы.
*   **Важно только вызвать вызов srand ONCE в начале программы.**
*   Нет необходимости в повторных вызовах для генерации генератора случайных чисел (фактически, это сделает ваш номер менее равномерным распространяемый).
*   Обычно используемый метод заключается в том, чтобы засевать генератор случайных чисел с использованием часов, поскольку часы дают вам разные результаты каждый раз, когда вы смотрите на него. Итак, для семени вы можете взять время и подключить его к генератору случайных чисел.
*   Функция time () вернет время компьютера. Это выражается в терминах количества секунды, прошедшие с 1 января 1970 года (Эпоха).
*   Время функции (NULL) вернет количество секунд, прошедших в компьютерное время.
*   Файл заголовка, который должен быть включен для функций времени: \`ctime '.

Фрагмент кода:

```cpp
#include <ctime> 
 
 srand(time(NULL)); 
 cout << rand(); 
 
 /* 
 Output: (Will differ from computer to computer, and because of the seed, will also differ from time to time, literally. :D) 
 1696269016 
 */ 
```

Это дает разные значения при каждом запуске программы.

Бонус: Тонкая настройка rand () для вашего удобства.

*   Так как rand () возвращает случайное число от 0 до RAND\_MAX, если вы хотите, например, число от 0 до 8, -rand ()% 9. Любое число по модулю 9 вернет значение от 0 до 8.
    
*   Более формально, если вы хотите, чтобы число между L (включительно) и U (включительно), вы должны сделать `int num = L + rand()%(U-L+1).` Объяснение: - rand ()% (UL + 1) возвращает случайное (псевдослучайное, не забытое) число с 0 и (UL). Следовательно, добавление L гарантирует, что мы получим значение между L и U.
    
    Резюме:-
    

1.  int rand (): возвращает случайное число между 0 и RAND\_MAX.
    
2.  void srand (int seed): используется для засева генератора случайных чисел. Достаточно вызвать эту функцию только _один раз_ .
    
    ### Источники: - [Генерация случайных чисел](http://www.math.uaa.alaska.edu/~afkjm/csce211/handouts/RandomFunctions)