---
title: IDE and Printing different text 
localeTitle: IDE и печать другого текста
---
# Введение в IDE и печать другого текста:

*   В последней статье приведены некоторые ссылки для загрузки программного обеспечения, необходимого для программирования. Программное обеспечение, подобное этому, известно как IDE. **IDE означает интегрированную среду разработки**

## IDE в основном состоят из 3-х видов программного обеспечения:

**1 Редактор:** слегка измененный текстовый редактор, облегчающий кодирование. Примером редактора для кодирования является Notepad ++.

**2 Debugger:** программное обеспечение, которое помогает вам находить ошибки в вашей программе и разрешать их перед выполнением. Представьте, что FaceBook рушится при загрузке приложения или сбое игры внезапно. Чтобы предотвратить ошибочное выполнение программы, отладчик является лучшим другом программиста.

**3 Компилятор:** компилятор - это часть компьютера, которая преобразует ваш программный код высокого уровня в простой машинный код: 0s & 1s; так что компьютер понимает команды и выполняет их. С этого момента мы часто будем обсуждать **компилятор** слов.

_В: Попробуйте найти IDE в Google и запустить на нем свою первую программу. Проверьте выход_

Теперь установите IDE и попробуйте изменить текст из программы в последней статье.

### Изменение текста на C ++

*   Чтобы изменить текст, измените то, что набрано в `""` после `cout<<`

Пример программы:

```cpp
#include <iostream> 
 using namespace std : 
 int main() 
 { 
    cout << "I Love freeCodeCamp ! "; 
 } 
```

Вышеприведенный код возвращает ошибку, потому что в строке 2 мы использовали двоеточие (:) вместо точки с запятой (;) Итак, давайте отлаживаем ошибку:

```C++
#include <iostream> 
 using namespace std ; 
 int main() 
 { 
    cout << "I Love freeCodeCamp ! "; 
    return 0; 
 } 
```

Обратите внимание, что теперь программа работает отлично. Выход будет: `I Love freeCodeCamp!`

### Теперь давайте сменим текст на нечто подобное:

```cpp
    cout << "Hello World!\t I love freeCodeCamp!"; 
```

На этот раз на выходе будет что-то другое:
```
Hello World!     I love freeCodeCamp! 
```

Если вы поняли, команда `\t` создала _пространство_ между двумя текстами. Это одна из специальных команд на C ++. Эти специальные команды называются _Escape Sequences_ . Они используются для печати определенных специальных символов, которые компилятор не может отобразить.

#### Полезные escape-последовательности:

*   `\'` для печати одной перевернутой запятой
*   `\"` для печати двойной перевернутой запятой
*   `\n` для печати на новой строке
*   `\t` для горизонтальной вкладки
*   `\f` для новой страницы
*   `\\` для обратной косой черты
*   `\?` для вопросительного знака

##### Теперь попробуем напечатать числа и специальные символы с некоторыми escape-последовательностями:

```cpp
    cout << "40158 \t 236708 ! \n \\ @ \?" << endl; 
```

Выход изменяется на:
```
40158      236708 ! 
 \ @ ? 
```

##### Давайте попробуем другие способы печати:

```cpp
    cout << "1+2" << endl; 
    cout << 1+2 << endl; 
```

Вывод:

*   Первый выходной оператор равен `1+2`
*   Второй вывод - `3`

Это связано с тем, что мы не добавляли перевернутые запятые для второго оператора печати, поэтому компилятор добавил номера перед их печатью.

#### Комментарии:

*   Комментарии - важная особенность многих языков программирования. Они позволяют программисту делать заметки для самостоятельной помощи и не будут влиять на работу программы.

**Различные типы комментариев и синтаксис комментария** :

1 `//` ~ _Однострочные комментарии_ : длина этих комментариев - 1 строка (строка, на которую она введена). 2 `/* */` ~ _Multi Line Комментарии_ : Эти комментарии могут занимать место более чем одной строки.

#### Пример использования комментариев:

\`\` \`Каст cout << "Hello Comment" << endl; // cout << "Hello Comment" << endl; , Комментарий к отдельной строке.
```
/* This is an example of a multi line comment. No output is generated for this . 
 I now end the comment.  :) */ 
```

\`\` \`

Выход будет:

`Hello Comment`

Как вы можете заметить, комментарии игнорируются во время выполнения программы и не отображаются при проверке вывода программы. Следует отметить, что, хотя комментарии добавляют дополнительный уровень удобочитаемости к своему коду, плохой привычкой слишком полагаться на комментарии для описания логики вашего кода. В общем, ваш код должен говорить сам за себя и отражать намерение программиста.

Как вы можете заметить, комментарии игнорируются во время выполнения программы и не отображаются при проверке вывода программы.

#### операторы

*   Операторы позволяют сравнивать два или более выражения
*   `==` равно
*   `!=` не равна
*   `<` меньше
*   `>` больше, чем
*   `<=` меньше или равно
*   `>=` больше или равно

```cpp
    (7==5); 
```

Это оценивается как false

`cpp (7!=5);` Это соответствует истинному

[Суммирование всех операторов печати, используемых в этой статье. Не стесняйтесь настраивать код! :)](https://repl.it/L4ox)