---
title: The Auto Feature
localeTitle: Автофункция
---
## Автофункция

`auto` - это функция C ++ 11, которая позволяет компилятору вывести тип данных для вас в определении. Это может сэкономить вам много информации, особенно со сложными типами.

Без `auto` :

```cpp
double x = 10.425; 
 double y = x * x; 
```

С `auto` :

```cpp
double x = 10.425; 
 auto y = x * x; 
```

Хотя это может показаться тривиальным, становится невероятно полезным, когда типы данных начинают усложняться. Например, предположим, что вы хотите сохранить [`vector`](https://guide.freecodecamp.org/cplusplus/vector) сотрудников, и вас интересует только их имя и возраст. Одним из способов хранения имени и возраста может быть `pair` со `string` и `unsigned int` . Это объявляется как `std::vector<std::pair<std::string, unsigned int>> employees` . Теперь предположим, что вы хотите получить доступ к последнему добавленному сотруднику:

```cpp
std::vector<std::pair<std::string, unsigned int>> employees; 
 
 // without auto, you have to write: 
 std::pair<std::string, unsigned int>> last_employee = employees.back(); 
 
 // with auto, you just have to write: 
 auto last_employee = employees.back(); 
```

Как только компилятор определит тип в правой части `=` он заменяет `auto` этим типом.

В современных версиях C ++ (начиная с C ++ 14) `auto` можно также использовать в объявлении функции как возвращаемый тип. Затем компилятор выводит возвращаемый тип из оператора return внутри функции. Следуя примеру сотрудников:
```
std::vector<std::pair<std::string, unsigned int>> employees; 
 auto get_last_employee() { 
    return employees.back(); // Compiler knows the return type from this line. 
 } 
```

Компилятор будет знать из строки с оператором return, что тип возврата из функции должен быть `std::vector<std::pair<std::string, unsigned int>>` .

В то время как довольно технически, [страница cppreference на авто](http://en.cppreference.com/w/cpp/language/auto) описывает еще много [способов](http://en.cppreference.com/w/cpp/language/auto) использования `auto` и деталей, когда это возможно и не может быть использовано.

### `auto` перед C ++ 11

В некоторых старых учебниках, содержащих _очень_ старый код, ключевое слово `auto` используется совсем по-другому.

Этот конкретный `auto` был ключевым словом, заимствованным из C, и, вероятно, был наименее используемым ключевым словом всех времен.

В C ++ все переменные имеют _автоматическую продолжительность_ , то есть они определяются до тех пор, пока вы не выйдете из функции, в которой они определены.

Например:

\`\` \`Каст

# включают

int main () { int a; a = 1; // имеет смысл, поскольку он был определен в той же функции
```
    return 0; 
```

} a = 2; // не имеет смысла, так как a здесь не определен \`\` \`

Это задано в C ++, и `auto` указывает, что переменная должна иметь _автоматическую продолжительность_ , следовательно, отсутствие использования.

## Дальнейшее чтение :

*   http://www.stroustrup.com/C++11FAQ.html#auto