---
title: Operators
localeTitle: операторы
---
# Операторы:

*   Операторы позволяют выполнять операции с вашими данными.
*   Данные, которые работают, называются _операндами_ .
*   Различные типы операторов в C ++:
*   _OPERANDS_ - это данные, на которых оператор выполняет определенные команды.
*   Операторы имеют 3 типа: унарный (работает на 1 операнд), двоичный (работает на 2 операнда), тройной (работает на 3 операнда).

### 1 Операторы ввода / вывода -

*   Эти операторы позволяют вам направлять ввод и вывод.
    
    ## Входной оператор «>>» ##
    
    используется для чтения данных со стандартного ввода (инструкция «cin»).
    
    ## Оператор вывода «<<»
    
    используется для отправки вывода в инструкции `cout` .
    

### 2 Арифметические операторы -

*   Эти операторы позволяют выполнять основные арифметические операции.

1.  Оператор `+` _добавляет_ два операнда.
    
2.  Оператор `-` _вычитает_ два операнда.
    
3.  Оператор `*` _умножает_ два операнда.
    
4.  Оператор `/` _делит_ и дает _частное_ от двух операндов.
    
5.  Оператор `%` _делит_ и дает _оставшуюся_ часть двух операндов. (Или, для более математически наклоненного читателя, `a % b` является, по существу, результатом «mod b»,
    
    ### Пример использования арифметических операторов:
    
    \`\` \`Каст
    

# включают

использование пространства имен std;

int main () { int a = 5; // 1-й операнд int b = 10; // Второй операнд
```
    cout << "+ operator " << a+b << "\n"; //Add 
    cout << "- operator " << ab << "\n"; //Subtract 
    cout << "* operator " << a*b << "\n"; //Multiply 
    cout << "/ operator " << b/a << "\n"; //Find Quotient 
    cout << "modulus operator " << b%a << "\n"; //Find remainder 
 
    return 0; 
```

} \`\` \`

ВЫХОД :
```
+ operator 15 
 - operator -5 
 * operator 50 
 / operator 2 
 modulus operator 0 
```

[Попробуйте код самостоятельно! :)](https://repl.it/Mge9)

### Оператор приращения:

*   `++` известен как оператор приращения. Он увеличивает значение целочисленной переменной на 1.

2 типа приращения:

*   Pre increment сначала увеличивает значение, а затем использует его. Пример: `int a ; ++a;`
*   Приращение прихода сначала использует переменную, а затем увеличивает ее. Пример: `int b; b++;`

### Оператор декремента:

*   `--` известен как оператор декремента. Он уменьшает значение целочисленной переменной на 1.

2 типа декремента:

*   Предварительный декремент сначала уменьшает значение, а затем использует его. Пример: `int a ; --a;`
*   Пост-декремент сначала использует переменную, а затем уменьшает ее. Пример: `int b; b--;`

Пример операторов приращения и декремента:

```cpp
#include <iostream> 
 using namespace std; 
 
 int main() 
 { 
        int a = 3 ,b = 4; 
 
         // INCREMENT 
        cout<< "Value of int a PRE INCREMENTED : " << ++a << "\n"; 
        cout<< "Value of int b POST INCREMENTED : " << b++ << "\n"; 
        cout<< "Value of b is changed after using once : " << b << "\n"; 
 
         // DECREMENT 
        cout << "\n"; //go to next line 
        a = 10; //Assigning a new value to a 
        b = 10; //Assigning a new value to b 
        cout << "Value of int a PRE DECREMENTED : " << --a << "\n"; 
        cout << "Value of int b POST DECREMENTED : " << b-- << "\n"; 
        cout << "Value of b is changed after using once : " << b << "\n"; 
 
        return 0; 
 } 
```

ВЫХОД :
```
Value of int a PRE INCREMENTED : 4 
 Value of int b POST INCREMENTED : 4 
 Value of b is changed after using once : 5 
 
 Value of int a PRE DECREMENTED : 9 
 Value of int b POST DECREMENTED : 10 
 Value of b is changed after using once : 9 
```

[Попробуйте код самостоятельно! :)](https://repl.it/Mgg4/2)

### 3: Реляционные операторы:

*   Эти операторы сообщают нам отношение между 2 операндами и возвращают логическое значение (0 или 1). Если отношение `true` то это приводит к 1. Если realtion ложно, то результат равен 0.
    
*   6 реляционными операторами:
    
    1.  Менее `<`
    2.  Больше чем `>`
    3.  Меньше или равно `<=`
    4.  Больше или равно `>=`
    5.  Равно `==`
    6.  Не равно `!=`

### 4: Логические операторы:

*   Эти операторы объединяют выражения для логических операций. Они есть :

1.  Логическое AND `&&` : оценивает значение true, если оба значения истинны.
    
2.  Логический ИЛИ `||` : Вычисляет значение true, если какое-либо значение истинно.
    
3.  Логически НЕ `!` : Если _выражение_ истинно, _выражение!_ False. Этот оператор меняет значение истины и является унарным оператором.
    
    ### 5\. Тернарные операторы:
    
    Оператор `?:` Это тернарный оператор или _условный оператор_ , потому что его можно использовать для замены оператора `if else` или даже `if else if` . Синтаксис:
    

`condition ? ValueIfTrue : ValueIfFalse` . Это расширяется до:

```cpp
if(condition) 
 ValueIfTrue; 
 else ValueIfFalse; 
```

Вызов значения `ValueIfTrue` немного неверно, так как это не должно быть число. Что-то вроде этого:

`condition ? FirstLevelTrueValue : ConditionIfFalse ? SecondLevelTrueValue : SecondLevelFalseValue` также работает и интерпретируется как следующий `if else if` statement:

```cpp
if(condition) 
 FirstLevelTrueValue; 
 else if(ConditionIfFalse) 
 SecondLevelTrueValue; 
 else SecondLevelFalseValue; 
```

Аналогично, вложенные операторы `if` также могут быть сделаны с использованием тернарных операторов.

_Camper, Теперь вы знаете, что означают эти знаки. Следующая статья будет о_ _ПОЗДРАВЛЯЕМ_

**Удачи всем вам**

**Счастливое кодирование! :)**

**Не стесняйтесь задавать любые вопросы на странице GitHub [FreeCodeCamp](https://forum.freecodecamp.org/) или [форуме FreeCodeCamp.](https://forum.freecodecamp.org/)**