---
title: Variables
localeTitle: переменные
---
Давайте обсудим что-то знакомое как переменные. Переменные напоминают ведро. Вы можете положить что-то в него, а затем изменить его после чего, когда это необходимо. В C ++ существует много типов переменных, таких как целые числа, строки, булевы и многие другие. Давайте рассмотрим простую программу с использованием целочисленных переменных. Целые числа хранят целые числа, положительные, отрицательные или нулевые. Целые числа не являются дробными числами, например, 1/2, 1/4 и 1/5. Давайте рассмотрим простую программу, которая использует целое число переменная.

```cpp
#include <iostream> 
 using namespace std ; 
 int main() 
 { 
    int a;          // Declare an integer variable a 
    a = 5;          // Assign value of 5 to variable a 
    cout << a;      // Display the value of variable a which contains 5 
    return 0; 
 } 
```

Когда вы выполняете эту программу, вы увидите 5 на экране

*   Обратите внимание, что в указанной выше программе // помещается после строк. Символ «//» предназначен для комментирования нашего кода. Код после символа «//» не выполняется в строке, где она помещена.
    
*   В строке 5 объявлена ​​простая целочисленная переменная.
    
*   В строке 6 значение 5 присваивается переменной a. Теперь, когда мы используем переменную a в нашей программе, ее значение будет равно 5 если мы не изменим его.
    
*   В строке 7 отобразится значение переменной a и 5 на экране.
    

### Объем переменных

Все переменные имеют свою область функционирования, и из этой границы они не имеют своей ценности, эта граница называется областью действия переменной. В большинстве случаев его между фигурными фигурными скобками, в которых объявляется переменная, существует переменная, а не вне ее. Мы изучим классы хранения позже, но на данный момент мы можем разделить переменные на два основных типа,

\* Глобальные переменные.

\* Локальные переменные.

#### Глобальные переменные

Глобальные переменные - это те, которые объявлены и могут использоваться на протяжении всего жизненного цикла программы любым классом или любой функцией. Они должны быть объявлены вне функции main (). Если объявлено только, они могут быть назначены разные значения в разное время в жизни программы. Но даже если они объявлены и инициализированы одновременно за пределами функции main (), тогда также им может быть присвоено любое значение в любой точке программы.

Пример: Только объявлено, а не инициализировано.

```cpp
include <iostream> 
 using namespace std; 
 int x;                // Global variable declared 
 int main() 
 { 
 x=10;                 // Initialized once 
 cout <<"first value of x = "<< x; 
 x=20;                 // Initialized again 
 cout <<"Initialized again with value = "<< x;` 
 } 
```

#### Локальные переменные

Локальные переменные - это переменные, которые существуют только между фигурными фигурными скобками, в которых объявлено. Снаружи они недоступны и приводят к ошибке времени компиляции.

Пример :

```cpp
include <iostream> 
 using namespace std; 
 int main() 
 { 
 int i=10; 
 if(i<20)        // if condition scope starts 
  { 
    int n=100;   // Local variable declared and initialized 
  }              // if condition scope ends 
 cout << n;      // Compile time error, n not available here 
 } 
```

Теперь давайте прочитаем о новом типе переменных-

#### Статическая переменная

Статические переменные: когда переменная объявляется как статическая, пространство для нее распределяется на время жизни программы. Даже если функция вызывается несколько раз, пространство для статической переменной выделяется только один раз, а значение переменной в предыдущем вызове переносится через следующий вызов функции. Это полезно для реализации сопрограмм в C / C ++ или в любом другом приложении, где необходимо сохранить предыдущее состояние функции. В условиях неспециалиста это означает, что нормальная переменная, выходящая за пределы области, теряет свою идентичность (значение), но статическая переменная имеет глобальную область действия и сохраняет ее значение до конца программы, но в отличие от глобальной переменной нет необходимости объявлять ее при запуске программы.

#### экстра-

Static - это ключевое слово в C ++, используемое для предоставления специальных характеристик элементу. Статические элементы выделяются хранилищем только один раз в течение жизненного цикла программы в области статического хранения. И у них есть объем до срока службы программы.

#### КОД-
```
#include <iostream> 
 #include <string> 
 using namespace std; 
 
 void howstaticworks() 
 { 
    static int count = 0;  // static variable 
    cout << count << " "; 
 
    /* value is updated and 
     will be carried to next 
     function calls*/ 
    count++; 
 } 
 
 int main() 
 { 
    for (int i=0; i<5; i++) 
        howstaticworks(); 
    return 0; 
 } 
```

#### Попробуйте сами

просто скопируйте код и вставьте его в указанную ссылку. Запуск на IDE-https://ideone.com/

Вывод: 0 1 2 3 4

Вы можете видеть в приведенной выше программе, что счетчик переменных считается статическим. Таким образом, его значение переносится через вызовы функций. Счетчик переменных не получает инициализацию за каждый раз, когда вызывается функция.

Давайте дадим тот же код попробовать, удалив «статическое» ключевое слово и угадав вывод и сравним его с одним из IDE. Статичность теперь преобразуется в обычную переменную