---
title: Delegates
localeTitle: Делегаты
---
## Делегаты

AC # делегат представляет ссылку на метод, который имеет заданный набор параметров и заданного типа возврата. Когда вы создаете экземпляр делегата, вы можете связать его с любой метод, совместимый с типом делегирования: имеет одинаковое количество параметров, каждое из которых тот же тип, и тип возвращаемого значения также одинаков.

Вы можете использовать метод экземпляра или статический метод, когда назначаете его делегату.

Делегат позволяет передавать методы как параметры другим методам.

Делегаты часто используются для реализации функций обратного вызова. Наиболее типичным примером являются обработчики событий: вы регистрируете метод, который должен вызываться всякий раз, когда происходит определенное событие (например, нажата кнопка мыши).

### Краткое описание для разработчиков

Делегаты похожи на указатели функций на языках типа C, таких как C или C ++. Однако они безопасны по типу. В отличие от простых указателей функций они содержат информацию об экземпляре объекта, метод которого будет вызываться при вызове делегата, и строгие проверки типов для аргументов и возвращаемое значение функции.

## пример

Вы объявляете делегата похожим на то, как вы объявляете функцию, но добавляете ключевое слово `delegate` . Например:

```csharp
    public delegate string StringOperation ( string s1, string s2 ); 
```

Любой метод, который принимает два `string` аргумента и возвращает `string` может быть назначен переменной этого типа делегата.

После того, как вы создали тип делегата, вы можете использовать его так же, как и любой другой тип. Вы можете объявить локальную переменную, других членов класса или передать их в качестве параметров другим методам.

```csharp
    StringOperation a; 
```

Перед вызовом делегата вам нужно будет присвоить ему значение. Предположим, что у нас есть метод конкатенации который имеет следующую реализацию:

```csharp
    private string Concatenate ( string one, string two ) { 
        return one + " " + two; 
    } 
```

Затем вы можете назначить это переменной делегата и вызвать ее как функцию.

```csharp
    StringOperation op = Concatenate; 
 
    string result = op("Hello", "World"); 
 
    Console.WriteLine ( result ); // print "Hello World" to the console 
```

## Больше информации

Подробнее о делегатах читайте [здесь](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/delegates/) .