---
title: Enumerations
localeTitle: Перечисления
---
# Перечисления

Перечисление представляет собой набор именованных целочисленных констант, которые объявляются с использованием ключевого слова `enum` .

## пример
```
enum Gender 
 { 
  Male, 
  Female 
 } 
```

По умолчанию значения integer начинаются с 0 и возрастают на 1, для каждого имени перечисления, т.е. Male = 0, Female = 1 и т. Д.

Их можно переопределить, указав целочисленное значение для любого из имен перечисления.

## пример
```
enum Gender 
 { 
  Male = 1, 
  Female 
 } 
```

В этом случае целочисленные значения начинаются с 1 и возрастают оттуда.

Чтобы использовать перечисление, вы можете объявить переменную своего типа и присвоить ей значение:

`Gender myVar = Gender.Male;`

Вы также можете указать значение имени перечисления в его базовое целочисленное значение и наоборот:
```
Console.WriteLine($"Male: {(int)Gender.Male}"); 
 Console.WriteLine($"Female: {(int)Gender.Female}"); 
```

## Вывод:
```
Male: 1 
 Female: 2 

```