---
title: Expression Bodied Methods and Properties
localeTitle: Методы и свойства выражения
---
# Методы и свойства выражения

Вы можете объявлять методы и свойства как выражение лямбда, без необходимости в блоке оператора. Этот синтаксис, предназначенный для простых реализаций, более краток, чем объявление регулярного метода или свойства, поскольку он устраняет необходимость в некоторых фигурных скобках и использовании явного оператора return.

Ниже приведен пример объявления обычного метода:

```csharp
public Point CreatePoint(int x, int y) 
 { 
    return new Point(x, y); 
 } 
```

Следующий результат дает тот же результат, но записывается как выраженный метод:

```csharp
public Point CreatePoint(int x, int y) => new Point(x, y); 
```

Вы также можете объявить свойства с помощью этого синтаксиса. Следующий код - это то, как мы объявляем свойство get-only без выражения лямбда:

```csharp
public Point Location 
 { 
    get 
    { 
        return _location; 
    } 
 } 
```

Благодаря выраженному телу мы можем уменьшить этот код до одной строки:

```csharp
public Point Location => _location 

```