---
title: Extension Mehods
localeTitle: Расширение Mehods
---
## Методы расширения

Методы расширения позволяют вам «добавлять» методы к существующим типам, не создавая новый производный тип, перекомпилировать или иным образом модифицировать исходный тип. Для кода клиента, написанного на C #, нет очевидной разницы между вызовом метода расширения и методами, которые фактически определены в типе.

Наиболее распространенными методами расширения являются стандартные операторы запроса LINQ, которые добавляют функциональность запроса к существующим System.Collections.IEnumerable и System.Collections.Generic.IEnumerable типы.

### использование

Методы расширения определяются как статические методы, но вызываются с помощью синтаксиса метода экземпляра. Их первый параметр указывает, на какой тип работает метод, и этому параметру предшествует этот модификатор. Методы расширения доступны только в том случае, если вы явно импортируете пространство имен в исходный код с **помощью** директивы **using** .

### пример

В следующем примере показан метод расширения, определенный для класса **System.String** .
```
namespace ExtensionMethods 
 { 
    public static class MyExtensions 
    { 
        public static int WordCount(this String str) 
        { 
            return str.Split(new char[] { ' ', '.', '?' }, 
                             StringSplitOptions.RemoveEmptyEntries).Length; 
        } 
    } 
 } 
```

Теперь вы можете привнести метод **WordCount** в область видимости с **помощью** директивы:
```
using ExtensionMethods; 
```

И вы можете вызвать его из приложения, используя этот синтаксис:
```
string s = "Hello Extension Methods"; 
 int i = s.WordCount(); 
```

#### Дополнительная информация:

[Практическое руководство. Внедрение и вызов настраиваемого метода расширения (Руководство по программированию на C #)](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/how-to-implement-and-call-a-custom-extension-method)