---
title: Garbage Collection
localeTitle: Вывоз мусора
---
## Вывоз мусора

#### Что такое сбор мусора?

Сбор мусора - это процесс, в котором программы пытаются освободить пространство памяти, которое больше не используется объектами и т. Д. Сбор мусора осуществляется по-разному для каждого языка. Большинство языков программирования высокого уровня имеют встроенную сборку мусора. Низкоуровневые языки программирования могут добавлять сборку мусора через библиотеки.

Как было сказано выше, каждый язык программирования имеет свой собственный метод GC. В программировании на C разработчикам необходимо позаботиться о распределении памяти и освобождении, используя функции `malloc()` и `dealloc()` . Для приложений C # разработчикам больше не нужно заботиться о GC, и это также не рекомендуется, потому что .NET framework уже справляется с этим.

\#### Как происходит распределение памяти? В C # распределение памяти в памяти происходит в управляемой куче, и это выполняется CLR (Common Language Runtime). Распределение памяти для кучи выполняется через win32.dll в операционной системе (OS), как и в C. Но в C объекты помещаются в память, если свободное пространство соответствует размеру объекта. И отображение памяти работает на основе концепций Linkedlist. В C # распределение памяти для кучи происходит линейным образом, то есть один за другим.

Всякий раз, когда создается новый объект, в куче выделяется память, и указатель переходит к следующему адресу памяти. Распределение памяти в C # быстрее, чем C. В C памяти необходимо искать и выделять для объекта, который добавляет некоторое накладное время.

\#### Поколения в C # GC В программировании .net куча имеет три поколения под названием Generation 0, 1, 2.

Генерация 0 заполняется сначала всякий раз, когда создается новый объект. Сборщик мусора запускается, когда поколение 0 заполняется. вновь созданные объекты помещаются в Generation 0. При выполнении сбора мусора все нежелательные объекты уничтожаются, память освобождается и уплотняется. GC заботится о том, чтобы указывать указатели освобожденной памяти после GC.

Поколения 1 и 2 имеют объект, который имеет более длительный срок службы. GC на поколениях 1 и 2 не будет происходить до тех пор, пока у поколений 0 не будет достаточной памяти для распределения.

Не рекомендуется использовать программный код GC. Хорошо, если это произойдет само по себе. GC выполняется всякий раз, когда заполняется поколение 0. GC не влияет на производительность приложения.

Сбор мусора - это процесс, в котором программы пытаются освободить пространство памяти, которое больше не используется переменными, объектами и т. Д. Сбор мусора осуществляется по-разному для каждого языка. Большинство языков программирования высокого уровня имеют встроенную сборку мусора. Низкоуровневые языки программирования могут добавлять сборку мусора через библиотеки.

Сбор мусора - это инструмент, который экономит время для программиста, например, он заменяет необходимость в таких функциях, как malloc () и free (), которые находятся на C. Это также помогает предотвратить утечку памяти.

Недостатком сборки мусора является то, что это негативно сказывается на производительности. Программа должна регулярно запускаться по программе, проверять ссылки на объекты и очищать память - это требует ресурсов и часто требует приостановки программы.

Если объект не имеет ссылок (больше недоступен), он имеет право на сбор мусора. Например, в приведенном ниже коде Java объект Thing, на который первоначально ссылается «thing1», имеет свою единственную ссылку, перенаправленную на другой объект в куче, - тогда он недоступен и будет иметь память, нераспределенную сборщиком мусора.

#### Дополнительная информация:

\- \+ - https://docs.microsoft.com/en-us/dotnet/standard/garbage-collection/fundamentals - узнать больше о сборке мусора