---
title: C#
localeTitle: C #
---
## C #

C Sharp, обычно называемый «C #», является универсальным, объектно-ориентированным языком программирования. C # был разработан Андерсом Хейлсбергом и его командой разработчиков в Microsoft и в настоящее время находится на версии 7.0.

C # имеет свои корни в семействе языков C. Он наследует большинство своих функций от C, C ++ и Java. По этой причине программисты, знакомые с этими языками, могут получить возможность ускорить работу с C # за более короткий промежуток времени.

C # - объектно-ориентированный язык, обеспечивающий поддержку компонентно-ориентированного и функционального программирования.

#### Классы и объекты

Классы позволяют нам моделировать повседневные объекты в окружающем нас мире в программном обеспечении. Вы можете создавать пользовательские классы, чтобы представлять что угодно. Точно так же, как существительное - человек, место или вещь на языке, тоже классы представляют объекты.

Когда вы пишете код C #, как правило, это потому, что вам нужна программа, которая делает что-то полезное. В случае необходимости бизнеса вы выполняете требования, необходимые для бизнеса. Скажите, что ваш бизнес приходит к вам, просит вас получить электронную базу данных книг. Они должны иметь возможность хранить названия книг, авторов, вычислять статистику, например количество проверок в данном месяце или среднемесячное число. Требования описывают программу, которая должна быть разработана. Как вы пишете программу для данных требований? Как правило, мы используем классы для создания абстракций для разных существительных, с которыми нам нужно работать. Существительное, такое как книга, автор или название.

Важной концепцией в C # является то, что определение класса используется для создания экземпляров объектов. Вы можете думать об этом как о плане создания экземпляров объектов. Определение класса позволяет создавать объекты, которые хранят ссылку на этот объект. Например, предположим, что мы хотим создать новый объект книги. Строка кода выглядит так:

`Book book = new Book();`

Это создает новый объект книги, который мы можем использовать для управления данными и хранения их в базе данных. Переменная, книга, на самом деле является ссылочным типом Книги (с капиталом B). Мы можем использовать методы, доступные в определении класса, с этой переменной, например, AddTitle () или AddAuthor () и т. Д.

#### Особенности C # включают:

1.  Автоматическая сборка мусора
2.  Обработка исключений
3.  Тип-безопасности
4.  Versioning
5.  Делегаты
6.  свойства
7.  LINQ (языковой интегральный запрос) и лямбда-выражения
8.  Дженерики
9.  индексаторы
10.  Многопоточность

#### Новые возможности добавлены в C # 7.0:

1.  Deconstructors
2.  Новый синтаксис для работы с Tuples
3.  Согласование шаблонов с выражением
4.  Локальные функции
5.  Возвращение по ссылке
6.  Переменные
7.  Условные улучшения
8.  Обобщенные типы возврата асинхронного типа
9.  Более выраженные члены
10.  Выразить выражения
11.  Тип записи
12.  Минимизация OUT
13.  Недействительный ссылочный тип «NULL»

Вы можете использовать C # для создания клиентских приложений Windows, веб-служб XML, распределенных компонентов, клиент-серверных приложений, приложений баз данных и т. Д.

#### Приложения ASP.NET и .NET

Язык C # также используется с инфраструктурой ASP.NET, разработанной корпорацией Microsoft, специально для создания веб-приложений, независимых от машины и браузера. Более широкая платформа .NET, также разработанная Microsoft, используется для создания других типов приложений, таких как настольные, мобильные, серверные и сетевые приложения. .NET Framework включает библиотеки базового класса .NET (BCL), ASP.NET, ADO.NET, Windows Forms, Windows Presentation Foundation (WPF) и библиотеки расширяемого языка разметки (XML).

Дополнительные сведения об ASP.NET см. В разделе ASPNET в руководстве [freeCodeCamp](https://guide.freecodecamp.org/)

#### Дополнительная информация:

*   [Введение в C #](https://docs.microsoft.com/en-us/dotnet/csharp/getting-started/introduction-to-the-csharp-language-and-the-net-framework)
*   [Учебники C #](https://www.microsoft.com/net/tutorials/csharp/getting-started)
*   [Официальная документация на C #](https://docs.microsoft.com/en-us/dotnet/csharp/)
*   [Новые возможности в C # 7.0](https://msdn.microsoft.com/en-us/magazine/mt790184.aspx)