---
title: Inheritance
localeTitle: наследование
---
# наследование

Наследование позволяет создать класс, который расширяет или изменяет существующий класс. Это можно использовать для создания классов, которые выводятся из других классов.

# Базовый класс и класс Derived

Это термины, используемые для классов при обращении к наследованию. Производный класс наследует базовый класс вместе с любыми переменными, функциями или процессами, которые использует базовый класс. Затем производный класс может иметь свои собственные переменные и функции наряду с теми, которые он наследует от базового класса.

Например, базовый класс «Животное» может иметь производный класс «Собака». Класс Animal будет содержать функции, относящиеся к животным в целом, а класс Dog содержит уникальные для собак особенности. Когда класс Dog наследует класс Animal, он сможет ссылаться на обе функции, относящиеся к животным и особенностям, уникальным для собак.

# Правила наследования

Наследование - это один из способов. Базовый класс не наследует функции производного класса.

Наследование транзитивно. Базовый класс «Животное» может иметь производный класс «Собака», и он может иметь производный класс «Терьер». Класс Terrier наследует как свойства класса Dog, так и класс Animal.

# Символ `:`

В C # Если `:` символ используется для обозначения наследования. Это вызывается при создании производного класса.

## пример

# Базовый класс
```
public class Animal 
 { 
    public int ID; 
    public string title; 
    public enum phylum; 
    public enum dietType; 
 
        public DefineAnimal(int id, string name, enum phy, enum diet) 
    { 
        this.ID = id; 
        this.title = name; 
        this.phylum = phy; 
        this.dietType = diet; 
    } 
 } 
```

# Производный класс
```
public class Dog : Animal 
 { 
    public enum breed; 
    public int levelOfTraining; 
 
    public void SayWoof() 
    { 
        Console.WriteLine("Woof"); 
    } 
 } 

```