---
title: Interface
localeTitle: Интерфейс
---
* * *

Интерфейс похож на класс или структуру, но без реализации для его членов. Интерфейс объявляет контракт или поведение, которое должны иметь классы реализации. Он может объявлять только свойства, методы и события без модификаторов доступа NO.

Все объявленные участники должны быть реализованы в классе, предназначенном для ангаров, иначе будет ошибка компиляции. в качестве условного обозначения мы будем отмечать интерфейс с буквой I при запуске (IMyInterface || IUserOptions). Вы определяете интерфейс, используя ключевое слово интерфейса.

Все члены интерфейса: неявно абстрактно, неявно публичный, не может объявить модификатор доступа, такой как защищенный, внутренний частный и т. д. ...

Интерфейс может:

*   Наследовать от других интерфейсов.
*   Наследовать от нескольких интерфейсов одновременно
*   Содержит только методы, свойства, события и индексаторы.

Интерфейс не может:

*   Наследовать от класса.
*   Имейте реализацию.
*   Имеют модификаторы доступа, кроме публики.

## \* Будь создан.

Использование интерфейсов позволяет нам изменить нашу реализацию в нашем проекте, не нарушая других частей, и только нужно изменить одно место, где создается объект.

Пример интерфейса:

```csharp
public Interface IUserFavoriteFood
 {
  void AddFood();
  Task<User> EatFavoriteFood(int id);
 }
```

* * *

Наследование интерфейсов и их реализация:

```csharp
public class UserHungry : IUserFavoriteFood
 {
  public AddFood()
  {
    // Implementation:
    // A method to add food.
  }

  public Task<User> EatFavoriteFood(int id)
  {
    // Implementation:
    // A method to Eat food by id.
  }
 }

```