---
title: nameof Expressions
localeTitle: Имя выражения
---
# Имя выражения

Иногда вам требуется имя строки переменной, типа или члена для таких вещей, как сбор исключений, запись или изменение свойств измененных событий. До C # 6.0 вы можете использовать строковый литерал для таких целей.

# #
```
public void ProcessStudent(Student student) 
 { 
    if (student == null) throw new ArgumentNullException("student"); 
 } 
```

Однако, если параметр студента должен был быть переименован, вам также нужно будет запомнить строковый литерал. Теперь с выражениями nameof вам не нужно использовать строковые литералы, и компилятор сможет предупредить вас, если вы используете неправильное имя.

# #
```
public void ProcessStudent(Student student) 
 { 
    if (student == null) throw new ArgumentNullException(nameof(student)); 
 } 
```

Некоторые примеры того, где имена выражений могут быть полезными, включают:

*   Выбрасывание исключений при проверке параметров
*   Передача имени действия при настройке ссылок на действия MVC
*   Необходимо передать имя свойства при запуске события с измененным свойством в классе, который реализует INotifyPropertyChanged
*   Передача имени свойства при регистрации свойства зависимости XAML
*   Включение имени переменной, типа или имени при регистрации

Следует отметить, что если вы укажете имя с квалифицированным именем, компилятор сгенерирует строку для самого правого имени.