---
title: String Interpolation
localeTitle: Интерполяция строк
---
# Интерполяция строк

В C #, как правило, для конкатенации строк вы либо используете оператор «+», либо составное форматирование с помощью метода, такого как String.Format. При комбинированном форматировании я имею в виду строку формата с индексированными заполнителями (элементы формата) и список объектов, которые будут использоваться в заполнителях.

# #
```
string message = "Hello " + firstName + " " + lastName + "!"; 
 
 string message2 = string.Format("Hello {0} {1}!", firstName, lastName); 
```

С помощью интерполированных строковых выражений у вас есть строка с содержащимися выражениями, которые заменяются результатами выражений. Вы должны префикс своего строкового литерала знаком доллара ($). Выражения, которые вы хотите включить в строку, помещаются в строку, заключенную в фигурные скобки. Вышеприведенное сообщение будет выглядеть следующим образом:

# #
```
string message = $"Hello {firstName} {lastName}!"; 
```

**Небольшая полезная информация** В строковой интерполяции вы можете вызывать функции, свойства и тернарные операторы:
```
int a = 3; 
 int b = 454; 
 string result = $"{a}+{b} = {a+b}"; 

```