---
title: While Loop
localeTitle: Пока цикл
---
# Пока цикл

Цикл while выполняет блок кода до тех пор, пока указанное условие не станет ложным. Поскольку проверка выражения while выполняется перед каждым исполнением цикла, цикл while выполняет ноль или более раз. Это отличается от цикла do, который выполняется один или несколько раз, потому что проверка выражения происходит после выполнения цикла. 1

## пример

```csharp
int i = 0; 
 while (i < 5) 
 { 
    Console.WriteLine("Number " + i); 
    i++; 
 } 
```

### Вывод:
```
> Number 0 
 > Number 1 
 > Number 2 
 > Number 3 
 > Number 4 
```

## Другие виды использования

Петли while часто используются для бесконечных иерраций, используя (например) `while (true)` , только для того, чтобы быть завершенным условием, не связанным с начальным условием цикла.

```csharp
int i = 0; 
 while (true) 
 { 
    if(i<50){ 
        Console.WriteLine("Number " + i); 
        i++; 
    } 
    else{ 
        Console.WriteLine("End of loop"); 
        break; 
    } 
 } 
```

## Отличия от цикла `for`

Наибольшие различия между циклами `for` и `while` заключаются в том, что в `while` как обычно используется, когда разработчик не уверен в точном числе итераций цикла, а `for` используется, когда становится ясно, сколько раз перебирать код.

### источники

*   [Microsoft C # - пока](https://docs.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/while)