---
title: Background Opacity
localeTitle: Непрозрачность фона
---
## Непрозрачность фона

Свойство прозрачности (opacity) указывает на прозрачность/непрозрачность элемента, то есть на степень видимости содержимого за элементом.

Свойство прозрачности может принимать значение от 0.0 до 1.0. Чем ниже значение, тем больше прозрачность:

Подробнее [здесь](https://www.w3schools.com/css/css_image_transparency.asp)

Вы можете выбрать насколько вы хотите сделать элемент прозрачным. Для достижения уровня прозрачности вам необходимо добавить следующее свойство CSS.

**Полностью непрозрачный**

```css
.class-name { 
  opacity:1; 
 } 
 
 или 
 
 .class-name { 
  opacity:1.0; 
 } 
```

**Полупрозрачный**

```css
.class-name { 
  opacity:0.5; 
 } 
 Значение непрозрачности может быть любым от 0 до 1;
```

**Прозрачный**

```css
.class-name { 
  opacity:0; 
 } 
 
 или
 
 .class-name { 
  opacity:0.0; 
 } 
```

В качестве альтернативы вы можете использовать прозрачное значение rgba следующим образом: 

```css

.class-name{
  background-color: rgba(0,0,0,.5);
  }
 ```
В приведенном выше примере, фон имеет черный цвет с прозрачностью 50%. Приведенный выше пример указывает, что фон имеет черный цвет с непрозрачностью 50%. Последним значением значения rgba является альфа-значение. Значение альфа 1 равно 100%, а 0.5 (.5 для краткости) равно 50%. Мы используем этот метод для добавления прозрачности к элементу, не затрагивая содержимое внутри.

[Пример кода для отображения диапазонов непрозрачности фона](https://codepen.io/lvcoulter/full/dVrwmK/)

#### Дополнительная информация:

Для получения дополнительной информации посетите [MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/opacity) [Свойство CSS прозрачности в CSS-трюках](https://css-tricks.com/almanac/properties/o/opacity/)

Поддержка браузера: [caniuse](https://caniuse.com/#search=opacity)
