---
title: Before Selector
localeTitle: Перед селектором
---
## Перед селектором

CSS **:: before** selector может использоваться для вставки чего-либо перед содержимым элемента или элементов. Это позволяет дизайнеру выполнять любой дизайн css перед содержимым в элементе. Он используется путем присоединения **:: before** к элементу, для которого он должен использоваться.

Давайте посмотрим на некоторые примеры:

```css
p::before { 
    content: ""; 
    border: solid 5px #ccc 
 } 
 
 span.comment::before{ 
  content: "Comment: "; 
  color: blue; 
 } 
```

```html

<p> To infinity and beyond</p> 
 <p> I am buz lightyear, I come in peace.</p> 
 
 <span class="comment"> May the force be with you</span> 
 <br/> 
 <span> Do. Or do not. There is no try</span> 
```

В приведенном выше примере мы добавляем серая граница перед каждым элементом абзаца на странице, и мы также добавляем комментарий слова синим до каждого элемента span с комментарием класса.

> Вы можете посмотреть эту демонстрацию здесь https://jsfiddle.net/398by400/

#### Определение и использование

`::before` является одним из селекторов псевдоэлементов CSS, которые используются для стилизации определенных частей элемента. В этом случае мы можем вставлять содержимое перед некоторым HTML-элементом из CSS. Хотя мы увидим контент на странице, он не является частью DOM, что означает, что мы не можем манипулировать им из Javascript. Один трюк для решения этой проблемы: передача содержимого атрибутом данных и использование jQuery для его управления. Вот пример использования:

```css
   p::before { 
     content: "Hello "; 
   } 
```

```html

<p>world!!</p> 
```

Это покажет `Hello world!!` на странице.

Не только строки, также изображения, счетчики или даже ничего («», полезные для clearfix) могут быть вставлены в attitute `content` , но **не в HTML** . Есть много интересных вещей, которые можно сделать с помощью `::before` и `after` творческим способом. Вы можете взглянуть на следующую ссылку, если вам интересно: [целая куча удивительных элементов псевдоэлементов может сделать](https://www.w3schools.com/css/css_pseudo_elements.asp)

#### Одиночная двоеточие против двойной толстой кишки

Немного обсуждается правильный способ использования псевдоэлементов: старый стиль single-colon ( `:before` ), используемый в спецификациях 1 и 2 CSS, в сравнении с рекомендацией CSS3, double-colon ( `::before` ), в основном для _«установления дискриминация между псевдоклассами и псевдоэлементами »_ . Но по соображениям совместимости единственная двоеточие все еще принимается. Говоря о совместимости, IE8 поддерживает только одноточечную запись.

#### Дополнительная информация:

[W3Schools CSS Псевдоэлементы](https://www.w3schools.com/css/css_pseudo_elements.asp)

[CSS-Tricks :: after / :: before](https://css-tricks.com/almanac/selectors/a/after-and-before/)

[Выбор и управление псевдоэлементами CSS, такими как :: before и :: после использования jQuery](https://stackoverflow.com/questions/5041494/selecting-and-manipulating-css-pseudo-elements-such-as-before-and-after-usin)