---
title: Border Property
localeTitle: Свойство Border
---
## Свойство Border

## CSS Border

Наш любимый CSS-атрибут позволяет полностью настраивать границы, которые появляются вокруг элементов HTML. С HTML было невозможно разместить границу вокруг элемента, за исключением таблицы. CSS Borders позволяет создавать четкие, настраиваемые стили границ с очень небольшой работой по сравнению с устаревшими методами HTML.

Свойство `border` сокращенно устанавливает все свойства границы в одном объявлении.
```css 
  border: 1px solid #000;
```

Свойства должны быть заданы в порядке: 
 1. `border-style` 
 2. `border-width` 
 3. `border-color` 
 4. `border-radius` 
 
Не важно если одно из свойств будет пропущено, пример:
 
```css 
  border: solid red;
```
Этот код также будет верным. 
 
 ### Border Styles 
 
Свойтсво `border-style` задает различные стили границы. 
 
Возможные значения: 
 - `dotted` - граница из точек. 
 - `dashed` - граница из штрихов. 
 - `solid` - сплошная граница. 
 - `double` - двойная граница. 
 - `groove` - объемная рифленая граница. 
 - `ridge` - объемная ребристая граница. 
 - `inset` - объемная вдавленная границы. 
 - `outset` - объемная выдавленная граница. 
 - `none` - отсутствие границы. 
 - `hidden` - скрытая граница. 
 
На основе выбранного вами свойства эти стили могут быть несовместимы. 
Вы можете назначать каждый стиль отдельно: 
```css
  border-top-style: solid;
  border-left-style: dotted;
  border-right-style: dashed;
  border-bottom-style: double;
```

Или назначать несколько стилей одновременно: 
```css
  border-style: solid dashed double dotted;
```
Как видно свойство border позволяет выбрать различные части границы. [top, bottom, left, right] 
 
 ### Толщина границы 
 
Чтобы изменить толщину границы, используйте атрибут border-width. Вы можете использовать ключевые термины или точные значения для определения ширины границы. Примечание: Вы должны определить border-style для отображения границы. Ширина может быть задана как определенный размер (in px, pt, cm, em, etc) или используя одно из трех предопределенных значений: thin, medium, или thick. 
 
Пример: 
```css
<style type="text/css">
table {
	border-width: 7px;
	border-style: outset;
}
td {
	border-width: medium;
	border-style: outset;
}
p {
	border-width: thick;
	border-style: solid;
}
</style>
```

### Цвет границы 
 
Теперь переходим к творческму аспекту CSS Borders! С помощью атрибута border-color вы сможете создавать настраиваемые границы, чтобы соответствовать потоку и расположению вашего веб-сайта. Цвета границ могут быть любого цвета, определенного в системе RGB, шестнадцатеричным или ключевыми терминами. Ниже приведен пример каждого из этих типов.
 
Пример: 
```css
<style type="text/css">
table {
	border-color: rgb( 100, 100, 255);
	border-style: dashed;
}

td {
	border-color: #FFBD32;
	border-style: ridge;
}

p {
	border-color: blue;
	border-style: solid;
}
</style>
```

### Радиус границы 
Свойство `border-radius` позволяет сделать углы границы закругленными. Это возможно благодаря указанию размера на сколько граница должна быть закруглена. размер может быть задан в px или %.
```css 
  border-radius: 25px;
```
С помощью свойства `border-radius` может быть задано скругление для каждого угла. Порядок: верх, низ, лево, право. 
```css 
  border-radius: 15% 10px 30% 5px;
```

### Border: Все в одном 
 
Хотя хорошо, что CSS позволяет веб-разработчику быть очень специфичным в создании настраиваемой границы, иногда просто легче и меньше головной боли создавать единую границу, указывая все в одной строке кода CSS.
 
Пример: 
```css
<style type="text/css">
p { border: 20px outset blue; } 
h4 { border: 5px solid; } 
h5 { border: dotted; }
</style>
```

### Дополнительная информация:

- [MDN Documentation](https://developer.mozilla.org/en-US/docs/Web/CSS/border)
- [CSS3 Border Radius](https://guide.freecodecamp.org/css/css3-borders-rounded-corners)

### Другие атрибуты границы

*   'border-radius' - это может установить радиус границы.
*   'border-spacing' - это может установить интервал между текстом и границей.
*   'border-image' - устанавливает изображение как границу.

Поддержка браузера: IE6 +
