---
title: Breakpoints
localeTitle: Контрольные точки
---
## обзор

Точка перехвата CSS - это особая точка, в которой изменяется макет веб-сайта, на основе [медиа-запроса](https://guide.freecodecamp.org/css/css3-media-queries) становится активным.

Как правило, вы указываете точку останова, когда хотите повторно адаптировать макет сайта к размеру видового экрана браузера; в основном, до ширины окна просмотра.

Например, если контент вашего сайта отлично смотрится в узком окне просмотра (например, в браузере смартфонов), но он начинает плохо выглядеть на больших экранах (например, размер шрифтов слишком мал и его трудно читать), тогда вы может захотеть ввести новую точку останова для больших экранов, что делает шрифты больше:

Точки перехвата CSS могут считаться сердцем отзывчивого веб-дизайна, потому что они определяют, как ведет себя контент или организуется различная ширина / масштаб устройства, позволяющий пользователю показать наилучший макет для пользователя.

![пример](https://getflywheel.com/wp-content/uploads/2018/02/css-breakpoints-layouts-01.jpg)

## Настройка точек останова

Точки останова в целом устанавливаются на основе любого из следующих.

*   Точки останова на основе ширины устройства.
*   Точки останова на основе контента.

### Точки останова на основе ширины устройства

Совершенно очевидно, что все наши устройства имеют одинаковые ширины и размеры экрана. Теперь дизайнерское решение включает набор конкретных устройств и кодирует правила css соответственно. У нас уже достаточно устройств для беспокойства, и когда новый выходит с другой шириной, возврат к вашему CSS и добавление новой контрольной точки снова требует много времени.

Вот пример
```
/* ----------- iPhone 6, 6S, 7 and 8 ----------- */ 
 
 /* Portrait */ 
 
 @media only screen 
 
 and (min-device-width: 375px) 
 
 and (max-device-width: 667px) 
 
 and (-webkit-min-device-pixel-ratio: 2) 
 
 and (orientation: portrait) { 
 
 } 
 
 /* Landscape */ 
 
 @media only screen 
 
 and (min-device-width: 375px) 
 
 and (max-device-width: 667px) 
 
 and (-webkit-min-device-pixel-ratio: 2) 
 
 and (orientation: landscape) { 
 
 } 
 
 /* ----------- Google Pixel ----------- */ 
 
 /* Portrait */ 
 
 @media screen 
 
 and (device-width: 360px) 
 
 and (device-height: 640px) 
 
 and (-webkit-device-pixel-ratio: 3) 
 
 and (orientation: portrait) { 
 
 } 
 
 /* Landscape */ 
 
 @media screen 
 
 and (device-width: 360px) 
 
 and (device-height: 640px) 
 
 and (-webkit-device-pixel-ratio: 3) 
 
 and (orientation: landscape) { 
 
 } 
```

> При таком подходе вы получите огромный список медиа-запросов.

### Точки останова на основе контента

Это наиболее предпочтительный выбор при составлении или написании правил точки останова. Потому что упростить настройку вашего контента в соответствии с конкретным макетом только тогда, когда требуется изменение.
```
@media only screen (min-width: 768px){ 
 ... 
 } 
```

> Эта точка останова означает, что CSS будет применяться, когда ширина устройства составляет 768 пикселей и выше.

#### Вы также можете установить диапазон с точками останова, поэтому CSS будет применяться только в этих пределах.
```
@media only screen and (min-width: 768px) and (max-width: 959px){ 
 
 ... 
 
 } 
```

**Заметка** Всегда старайтесь создавать точки останова на основе собственного контента, а не устройств. Разделите их на логическую ширину, а не на произвольную ширину, и сохраните их на управляемом числе, поэтому изменение остается простым и понятным.

**Точки прерывания CSS** полезны, когда вы хотите обновлять стили на основе размера экрана. Например, с устройства размером 1200px и выше, используйте `font-size: 20px;` , либо используйте `font-size: 16px;` ,

То, с чего мы начали, - это ширина более 1200 пикселей, общая ширина экрана ноутбука. Вы также заметили, что мы упоминали «больше, чем», что означает, что мы в некотором роде используем что-то вроде утверждения « **если-то** ».

Давайте превратим его в код CSS:

```css
.text1 { 
    font-size: 16px; 
 } 
 @media (min-width: 1200px) { 
    .text1 { 
        font-size: 20px; 
    } 
 } 
```

**Для нашего удобства** сначала `.text1` основной стиль `.text1` ... затем мы укажем правила `@media` .

**Совет** . Вы можете увидеть на общей CSS-платформе под названием «Bootstrap», что они приняли **«минимальную ширину» и** в своем Bootstrap v4.0, по сравнению с их старым Bootstrap v3.0, используя **«max-width» и down** , Это только **предпочтение** , и нет ничего плохого в том, чтобы сказать « _этот_ размер и меньше» по сравнению с « _этим_ размером и больше».

Совершенно нормально использовать `@media (max-width) {}` . Вот пример:

```css
.text1 { 
    font-size: 20px; 
 } 
 @media (max-width: 1199px) { 
    font-size: 16px; 
 } 
```

```css
// Normal, basic styles 
 // that look great on small screens 
 // but not on bigger screens 
 body { 
  font-size: 16px; 
 } 
 
 // Define a new breakpoint, with a media query. 
 // In this case, for when the viewport's width 
 // is at least 512px wide. 
 @media (min-width: 512px) { 
    body { 
        font-size: 20px; 
    } 
 } 
```

Точки останова, основанные на содержимом, в отличие от устройства, менее сложны. Вот простой фрагмент `code 700px` который запускается, когда ширина устройства `code 700px` примерно по размеру экрана смартфона

```css
@media only screen and (min-width: 700px) { 
  something { 
    something: something; 
  } 
 } 
```

Вы также можете установить минимальную и максимальную ширину, что позволит вам экспериментировать с различными диапазонами. Это примерно триггер между smar-телефоном и большими размерами рабочего стола и монитора

```code
@media only screen and (min-width: 700px) and (max-width: 1500px) { 
  something { 
    something: something; 
  } 
 } 
```

#### Дополнительная информация:

*   [Отзывчивые точки останова](https://getbootstrap.com/docs/4.1/layout/overview/#responsive-breakpoints)
*   [Статья freecodecamp.org по использованию точек останова CSS](https://medium.freecodecamp.org/the-100-correct-way-to-do-css-breakpoints-88d6a5ba1862)
*   [Запросы мультимедиа CSS3](https://guide.freecodecamp.org/css/css3-media-queries)
*   [Определение точек останова](https://responsivedesign.is/strategy/page-layout/defining-breakpoints/)
*   [CSS-трюки: запросы @media](https://css-tricks.com/snippets/css/media-queries-for-standard-devices/)
*   [w3schools: Типичные точки останова устройства](https://www.w3schools.com/howto/howto_css_media_query_breakpoints.asp)