---
title: Class Selector
localeTitle: Селектор классов
---
## Селектор классов

Селектор классов используется в CSS-файле для применения стиля к элементам HTML с соответствующим именем класса. В HTML вы можете установить имя класса для любого элемента, добавив атрибут «class».

Чтобы выбрать элементы с определенным классом, мы используем (.), Названный как символ периода, с именем класса.

Например 

```css
.center { 
   text-align: center; 
   color: red;
}
```
Здесь все элементы HTML с `class="center"` будут красными и центрированными.

Примеры:

```html
<h1 class="test">This is a heading 1</h1> 
 <p class="test">This is a paragraph 1</p> 
 <h2 class="test">This is a heading 2</h2> 
 <p class="test">This is a paragraph 2</p> 
 <div class="test2 test3">This is a div 1</div> 
```

Так как имя класса не уникально, атрибут класса HTML позволяет определять одинаковые стили для элементов с тем же именем класса. **Вот как вы можете выбрать класс в файле CSS для стилей элементов (обратите внимание на нотацию):**

**Все элементы класса `test` будут применены в этом стиле:**

```css
.test { 
  color: green; 
 } 
```

**Все `<p>` элементы класса `test` будут применяться с этим стилем:**

```css
p.test { 
  border: 1px solid black; 
  color: red; 
 } 
```

**Все `<h1>` и `<h2>` Элементы класса `test` будут применяться с этим стилем:**

```css
h1.test, h2.test { 
  color: blue; 
 } 
```

**Все элементы, которые имеют как класс `test2` и `test3` будут применяться в этом стиле:**

```css
.test2.test3 { 
  color: green; 
 } 
```

_Совет: Не ставьте пробелы между несколькими классами_

#### Дополнительная информация:

Синтаксис и селектор CSS: [w3schools](https://www.w3schools.com/css/css_syntax.asp)
