---
title:  CSS3 Colors
localeTitle:  CSS3 Цвета
---
## Цвета

CSS Colors - это модуль CSS, который имеет дело с цветами, цветами, цветовым смешением и непрозрачностью. Не все свойства CSS, которые поскольку значение является частью этого модуля, но они зависят от него. В CSS вы можете изменить цвет почти любого элемента вашей HTML-страницы. Свойства, такие как `background-color` , `color` и `border-color` устанавливают цвет этих элементов.

CSS поддерживает названия цветов, шестнадцатеричные и RGB-цвета. В дополнение к объявлению `opacity` цвета в CSS3 теперь могут быть указаны с использованием имен цветов или значений RGB, HEX, HSL, RGBA, HSLA.

HTML поддерживает 140 стандартных [имен цветов](https://www.w3schools.com/colors/colors_names.asp) .

### RGB (A)

RGB означает «красный, зеленый, синий». Значение RGB представляет собой комбинацию значений интенсивности для красного, зеленого и синего. Каждый из них находится между 0 (черный) и 255 (полная интенсивность). Значения цветов RGBA являются расширением значений цвета RGB с альфа-каналом, который определяет непрозрачность для цвета. Альфа-параметр представляет собой число от 0,0 (полностью прозрачное) и 1,0 (полностью непрозрачное).

Значение цвета RGB задается с помощью: rgb (красный, зеленый, синий) Значение цвета RGBA аналогично, с альфа-значением в последнем положении: rgba (красный, зеленый, синий, альфа)

### HSL (А)

HSL означает «оттенок, насыщенность и легкость». Хюэ - это градус на цветном колесе (от 0 до 360): 0 (или 360) красный 120 - зеленый 240 - синий Насыщенность - это процентное значение: 100% - это полный цвет. Легкость также представляет собой процент; 0% темный (черный), а 100% белый. Значения цветов HSLA являются расширением значений цвета HSL с альфа-каналом, который определяет непрозрачность для цвета.

Значение цвета HSL задается с помощью: hsl (оттенок, насыщенность, легкость). Значение цвета HSLA аналогично, с альфа-значением в последнем положении: hsla (оттенок, насыщенность, легкость, альфа)

### CMYK

Цвета CMYK - это сочетание CYAN, MAGENTA, YELLOW и BLACK. На экранах компьютеров отображаются цвета с использованием значений цвета RGB. Принтеры часто представляют цвета с использованием значений цвета CMYK. CMYK не поддерживается в HTML, но предлагается в качестве нового стандарта в CSS4.

Примеры цветов: CMYK Red: cmyk (0%, 100%, 100%, 0%) CMYK Зеленый: cmyk (100%, 0%, 100%, 0%) CMYK Blue: cmyk (100%, 100%, 0%, 0%)

### Hexcodes

Hexcode, короткий для шестнадцатеричного кода, способ выразить значение цвета для вашего компьютера. Он назван таким образом, потому что в качестве значений могут использоваться 16 уникальных символов. В этом случае используются числа от 0 до 9 и буквы от a до f.

Шестнадцатеричные коды выражаются в этом формате: # 000000, который в этом случае будет черным цветом. Шесть символов используются в каждом шестнадцатеричном коде, используя любой из 16 символов, упомянутых ранее. Эти шесть символов разделены на три пары из двух.

Эти три пары выражают значение для красного, зеленого и синего в определенном цвете. Принимая цвет с шестнадцатеричным кодом # AA11BB, AA - это количество красного, 11 - зеленое, а BB - количество синего. 0 - наименьшее значение цвета, а f - наивысшее значение.

Hex-коды нечувствительны к регистру, что означает, что #FFFFFF и #ffffff будут одного цвета: белые.

Кроме того, имеется 16 777 216 возможных цветовых комбинаций с использованием шестнадцатеричного кода.

### Непрозрачность

Свойство opacity CSS3 задает непрозрачность для всего элемента (оба цвета фона и текст будут непрозрачными / прозрачными). В отличие от альфа-значений, заданных с помощью rgba и hsla, непрозрачность наследуется дочерними элементами.

Значение свойства непрозрачности должно быть числом от 0,0 (полностью прозрачным) и 1.0 (полностью непрозрачным).

#### Примеры

```html

<html> 
  <body> 
    <p>Hello Moto</p> 
  </body> 
 </html> 
```

```css
body { 
  background-color: green; 
  color: white; 
 } 
```

В приведенном выше примере `background-color: green` превращает элемент `<body>` зеленый. Это превратит всю веб-страницу в зеленый цвет. Элементы `<p>` все белые `color: white` . Вы можете использовать именованные цвета, такие как `green` , `blue` , `yellow` , `red` , `purple` и многие другие. Но для пользовательских цветов вы можете использовать шестнадцатеричные коды ( `#147ACC` ), значения RGB ( `rgb(20, 122, 204)` ) и даже значения HSL ( `hsl(145, 59%, 30%)` ).

```css
p { 
  color: rgba(244, 145, 14, 0.80); // bright orange 
 } 
 
 h2 { 
 color: #FA8072; //salmon 
 } 
```

Вы также можете добавить альфа-значение или прозрачность в цвета. Прозрачность позволяет накладывать текст на изображение и частично отображать изображение через текст или может использоваться для изменения оттенка цвета, если другие элементы не находятся впереди или позади текста. Используйте `rgba()` или `hsla()` и заполните ваши значения цвета. Альфа-значение длится последним и составляет процент, преобразованный в десятичное число. (Например, 20% составляет 0,2, 75% - 0,75 и т.д.)

```css
body { 
  background-color: hsl(184, 87%, 94%); // bright blue 
 } 
```

Выше показаны абзацы стилизованные ярко-оранжевые и 20% прозрачные, элементы h2 - лососевые розовые, а фон тела - ярко-синий.

Чтобы получить пользовательские цвета для использования в CSS, вы можете найти полезную подборку цветов. Некоторые текстовые редакторы имеют встроенные подборщики цветов, такие как Visual Studio Code. Если вы ищете «подборщик цветов» в Google или DuckDuckGo, вы получите набор цветов, который вы можете использовать. В Google Chrome и Firefox также есть надстройки для выбора цвета, которые вы можете установить. Adobe Color CC не только помогает вам выбрать цвет, но также поможет вам выбрать цветовую схему для вашей веб-страницы! Рекомендуется проверить, что у вас есть достаточно контраста между цветом текста и фона с помощью инструмента, такого как средство проверки цвета контрафакта WebAIM.

#### Дополнительная информация:

[Adobe Color CC](https://color.adobe.com/) [ColorPick Eyedropper в Интернет-магазине Chrome](https://chrome.google.com/webstore/detail/colorpick-eyedropper/ohcpnigalekghcmgcdcenkpelffpdolg?hl=en) [Добавление ColorZilla для Firefox](https://addons.mozilla.org/en-US/firefox/addon/colorzilla/) [Исследуйте разные цвета Hex](http://www.colorhexa.com/) [Проверка соответствия цвета WebAIM](https://webaim.org/resources/contrastchecker/)
