---
title: CSS Performance
localeTitle: Производительность CSS
---
## Производительность CSS

В большинстве случаев CSS не является причиной того, что ваша веб-страница загружается медленно. В некоторых случаях это может сократить время загрузки ваших сайтов, если ваш файл CSS загроможден сотнями неперфорированных селекторов. Вот некоторые основные рекомендации, как писать быстрый, поддерживаемый CSS.

### Производительность различных селекторов

Посмотрите на этот пример:

```css
#unique-id { }         // fastest 
 .general-class { }  // also fast 
 li { }              // ok 
 * { }               // slow 
```

Неудивительно, что селекторы ID являются самыми быстрыми, за ними следуют классы. Простые тег-элементы, такие как `div` или `li` , обрабатываются довольно медленно.

### Как выбран элемент

представьте себе следующий CSS:

```css
nav ul li a { 
  color: #fff; 
 } 
```

Это не очень хорошая идея. Есть лучшие способы выбора элемента ссылки в вашей навигации. Но как компьютер фактически выбирает правильный элемент? Сначала он находит каждый элемент на вашей странице. `a` Затем он проверяет, находится `li` внутри элемента `li` , внутри `ul` внутри `div` . Таким образом, браузер просматривает селектора справа налево. Если у вас есть сотни ссылок, это может занять некоторое время для обработки, так что вы должны делать?

### Улучшение производительности CSS

Как правило большого пальца:

*   Избегайте селекторов-потомков, таких как `ul li a` и т. Д.
*   Не уклоняйтесь от использования множества описательных имен классов `.footer-nav-link`
*   Попробуйте вместо этого использовать дочерний селектор, если вы хотите выбрать прямой дочерний элемент элемента `.image-container > img`
*   Избегайте использования универсальных селекторов `* { }`

### Это действительно все необходимо?

Возможно, это была проблема 20 лет назад, когда компьютеры были не такими быстрыми, как сегодня. Пожалуйста, не избегайте селекторов-потомков в будущем полностью. Но имейте в виду, что ваша цель состоит в том, чтобы написать поддерживаемый CSS, поэтому может потребоваться небольшое мышление. Иногда `nav ul li a` селектор не является такой хорошей идеей на странице, которая содержит сотни ссылок.