---
title: CSS Syntax and Selectors
localeTitle: Синтаксис и селектор CSS
---
## Синтаксис и селектор CSS

Когда мы говорим о синтаксисе CSS, мы говорим о том, как все складывается. Существуют правила о том, что происходит там, где вы можете писать CSS последовательно, и программа (например, браузер) может интерпретировать ее и правильно применять на странице.

Существует два основных способа написания CSS.

### Встроенный CSS

Специфические особенности CSS: [CSS-трюки](https://css-tricks.com/specifics-on-css-specificity/)

Inline CSS применяет стилирование к одному элементу и его дочерним элементам, пока не встретится другой стиль, переопределяющий первый.

Чтобы применить встроенный CSS, добавьте атрибут «style» к HTML-элементу, который вы хотите изменить. Внутри кавычек включается список пар ключ / значение с разделителями с запятой (каждый по очереди разделяется двоеточием), указывающий стили для установки.

Вот пример встроенного CSS. Слова «Один» и «Два» будут иметь цвет фона желтого и красного цветов. Слово «три» имеет новый стиль, который переопределяет первый и будет иметь цвет фона зеленого и цветного голубого цвета. В примере мы применяем стили к тегам `<div>` , но вы можете применить стиль к любому элементу HTML.

```html

<div style="color:red; background:yellow"> 
  One 
  <div> 
    Two 
  </div> 
  <div style="color:cyan; background:green"> 
    Three 
  </div> 
 </div> 
```

### Внутренний CSS

При написании встроенного стиля это быстрый способ изменить один элемент, есть более эффективный способ одновременного применения одного и того же стиля ко многим элементам страницы.

Внутренний CSS имеет свои стили, указанные в `<style>` , и встроен в `<head>` .

Вот пример, который имеет аналогичный эффект, например, пример «inline», за исключением того, что CSS был извлечен в свою область. Слова «Один» и «Два» будут соответствовать селектору `div` и будут красным цветом на желтом фоне. Слова «Три» и «Четыре» будут совпадать с селектором `div` , но они также соответствуют селектору `.nested_div` , который применяется к любому элементу HTML, который ссылается на этот класс. Этот более специфичный селектор переопределяет первый, и они в конечном итоге появляются как голубой текст на зеленом фоне.

```html

<style type="text/css"> 
  div { color: red; background: yellow; } 
  .nested_div { color: cyan; background: green; } 
 </style> 
 
 <div> 
  One 
  <div> 
    Two 
  </div> 
  <div class="nested_div"> 
    Three 
  </div> 
  <div class="nested_div"> 
    Four 
  </div> 
 </div> 
```

Селекторы, показанные выше, чрезвычайно просты, но они могут стать довольно сложными. Например, можно применять стили только к вложенным элементам; то есть элемент, который является дочерним элементом другого элемента.

Вот пример, где мы указываем стиль, который должен применяться только к элементам `div` которые являются прямым дочерним элементом других элементов `div` . В результате «Два» и «Три» появятся в виде красного текста на желтом фоне, но «Один» и «Четыре» останутся незатронутыми (и, скорее всего, черный текст на белом фоне).

```html

<style type="text/css"> 
  div > div { color: red; background: yellow; } 
 </style> 
 
 <div> 
  One 
  <div> 
    Two 
  </div> 
  <div> 
    Three 
  </div> 
 </div> 
 <div> 
  Four 
 </div> 
```

### Внешний CSS

У всех стилей есть свой собственный документ, который связан в `<head>` . Расширением связанного файла является `.css`

#### Дополнительная информация:

*   [Синтаксис CSS](https://developer.mozilla.org/en-US/docs/Web/CSS/Syntax) @ MDN
*   [Селекторы CSS](https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Selectors) @ MDN
*   [Ссылка на селектор CSS](https://www.w3schools.com/cssref/css_selectors.asp)
*   [Спецификация селекторов CSS](https://developer.mozilla.org/en-US/docs/Web/CSS/Specificity)