---
title: CSS3 2d Transforms
localeTitle: CSS3 2d Transforms
---
## CSS3 2d Transforms

Преобразования CSS3 позволяют вам переводить, поворачивать, масштабировать и перекосить элементы.

Преобразование - это эффект, который позволяет элементу изменять форму, размер и должность.

CSS3 поддерживает преобразования 2D и 3D.

## Поддержка браузера для 2D-трансформ

Номера в таблице указывают первую версию браузера, которая полностью поддерживает недвижимость.

Номера, за которыми следуют -ms-, -webkit-, -moz- или -о, указывают первую версию, которая работал с префиксом.

| Недвижимость | Хром | IE | Firefox | Сафари | Опера | | --------------------------------------- | ---------------------- | ------------------ | ------------------- | -------------------- | -------------------------------------------- | | трансформировать | 36,0 4,0 -webkit- | 10,0 9,0 -ms- | 16,0 3,5 -moz- | 9.0 3.2 -webkit- | 23,0 15,0 -webkit- 12,1 10,5 -o | | преобразовании координат (двухзначный синтаксис) | 36,0 4,0 -webkit- | 10,0 9,0 -ms- | 16,0 3,5 -moz- | 9,0 3,2 -webkit- | 23,0 15,0 -webkit- 12,1 10,5 -o |

## CSS3 2D-преобразования

Методы:

*   `translate()`
*   `rotate()`
*   `scale()`
*   `skewX()`
*   `skewY()`
*   `matrix()`

## Метод translate ()

Метод `translate()` перемещает элемент из текущего положения (согласно к параметрам, заданным для оси X и оси Y).

Следующий пример перемещает элемент `<div>` 50 пикселей вправо, а 100 пикселей вниз от текущей позиции:

### Пример:

```css
div { 
  -ms-transform: translate(50px, 100px); /* IE 9 */ 
  -webkit-transform: translate(50px, 100px); /* Safari */ 
  transform: translate(50px, 100px); 
 } 
```

## Метод rotate ()

Метод `rotate()` вращает элемент по часовой стрелке или против часовой стрелки в соответствии с данной степенью.

Следующий пример поворачивает элемент `<div>` часовой стрелке с 20 градусами:

### Пример:

```css
div { 
  -ms-transform: rotate(20deg); /* IE 9 */ 
  -webkit-transform: rotate(20deg); /* Safari */ 
  transform: rotate(20deg); 
 } 
```

Использование отрицательных значений приведет к вращению элемента против часовой стрелки.

Следующий пример поворачивает элемент `<div>` против часовой стрелки с помощью 20 градусы:

### Пример:

```css
div { 
  -ms-transform: rotate(-20deg); /* IE 9 */ 
  -webkit-transform: rotate(-20deg); /* Safari */ 
  transform: rotate(-20deg); 
 } 
```

## Метод scale ()

Метод `scale()` увеличивает или уменьшает размер элемента (согласно параметры, заданные для ширины и высоты).

Следующий пример увеличивает элемент `<div>` на два раза оригинальной ширины и в три раза от ее первоначальной высоты:

### Пример:

```css
div { 
  -ms-transform: scale(2, 3); /* IE 9 */ 
  -webkit-transform: scale(2, 3); /* Safari */ 
  transform: scale(2, 3); 
 } 
```

В следующем примере элемент `<div>` уменьшает половину его оригинала ширина и высота:

### Пример:

```css
div { 
  -ms-transform: scale(0.5, 0.5); /* IE 9 */ 
  -webkit-transform: scale(0.5, 0.5); /* Safari */ 
  transform: scale(0.5, 0.5); 
 } 
```

## Метод skewX ()

Метод `skewX()` элемент вдоль оси X на заданный угол.

Следующий пример пересекает элемент `<div>` 20 градусов по оси X:

### Пример:

```css
div { 
  -ms-transform: skewX(20deg); /* IE 9 */ 
  -webkit-transform: skewX(20deg); /* Safari */ 
  transform: skewX(20deg); 
 } 
```

## Метод skewY ()

Метод `skewY()` искажает элемент вдоль оси Y на заданный угол.

Следующий пример пересекает элемент `<div>` 20 градусов по оси Y:

### Пример:

```css
div { 
  -ms-transform: skewY(20deg); /* IE 9 */ 
  -webkit-transform: skewY(20deg); /* Safari */ 
  transform: skewY(20deg); 
 } 
```

## Метод skew ()

Метод `skew()` искажает элемент вдоль оси X и Y по заданным углам.

Следующий пример пересекает элемент `<div>` 20 градусов по оси X и 10 градусов по оси Y:

### Пример:

```css
div { 
  -ms-transform: skew(20deg, 10deg); /* IE 9 */ 
  -webkit-transform: skew(20deg, 10deg); /* Safari */ 
  transform: skew(20deg, 10deg); 
 } 
```

Если второй параметр не указан, он имеет нулевое значение. Итак, следующее пример перечеркивает элемент `<div>` 20 градусов по оси X:

### Пример:

```css
div { 
  -ms-transform: skew(20deg); /* IE 9 */ 
  -webkit-transform: skew(20deg); /* Safari */ 
  transform: skew(20deg); 
 } 
```

## Метод matrix ()

Метод `matrix()` объединяет все методы двумерного преобразования в один.

Метод matrix () принимает шесть параметров, содержащих математические функции, которые позволяет вращать, масштабировать, перемещать (переводить) и искажать элементы.

Параметры следующие: Матрица (Scalex (), skewY (), skewX (), ScaleY (), translateX (), translateY ())

### Пример:

```css
div { 
  -ms-transform: matrix(1, -0.3, 0, 1, 0, 0); /* IE 9 */ 
  -webkit-transform: matrix(1, -0.3, 0, 1, 0, 0); /* Safari */ 
  transform: matrix(1, -0.3, 0, 1, 0, 0); 
 } 
```

## Свойства преобразования CSS3

В следующей таблице перечислены все свойства 2D-преобразования:

| Недвижимость | Описание | | ---------------- | -------------------------------------------------- ------- | | трансформировать | Применяет преобразование 2D или 3D к элементу | | transform-origin | Позволяет изменить положение на преобразованных элементах |

## Методы 2D-преобразования

| Функция | Описание | | --------------------- | -------------------------------------------------- ----------------------- | | матрица (n, n, n, n, n, n) | Определяет 2D-преобразование, используя матрицу из шести значений | | переводить (x, y) | Определяет 2D-перевод, перемещая элемент вдоль оси X и Y. | translateX (n) | Определяет 2D-перевод, перемещая элемент вдоль оси X | | translateY (n) | Определяет 2D-перевод, перемещая элемент вдоль оси Y | | масштаб (x, y) | Определяет преобразование 2D-масштаба, изменяя ширину и высоту элементов | | scaleX (n) | Определяет преобразование 2D-масштаба, изменяя ширину элемента | | scaleY (n) | Определяет 2D-масштабное преобразование, изменяя высоту элемента | | вращение (угол) | Определяет двумерное вращение, угол указан в параметре | | косо (х-угол, у-угол) | Определяет двумерное косое преобразование вдоль оси X и Y. | skewX (угол) | Определяет двумерное косое преобразование вдоль оси X | | skewY (угол) | Определяет двумерное косое преобразование вдоль оси Y |

## Дополнительная информация:

*   https://css-tricks.com/almanac/properties/t/transform/
*   https://www.w3schools.com/css/css3\_2dtransforms.asp
*   https://developer.mozilla.org/en-US/docs/Web/CSS/transform