---
title: CSS3 Colors
localeTitle: CSS3 Цвета
---
## CSS3 Цвета

Цвета в CSS используются для раскрашивания элементов на наших веб-страницах. Существует множество способов присвоения цветов элементам. Вы можете использовать фактические имена цветов, их значения RGB или шестнадцатеричные значения. В CSS3 к спецификации добавлен hsl (оттенок-насыщенность).

### Цветные имена

В настоящее время в HTML поддерживается 140 имен цветов, которые могут быть назначены в правилах CSS, просто набрав их имя. Например:

### Синтаксис
```
p { 
  color: green; 
 } 
```

Это правило изменяет весь цвет шрифта для всех \\

элементы к зеленому. Полный список цветов 140 см. Здесь: https://www.w3schools.com/colors/colors\_names.asp

### Значения RGB

RGB означает «красный», «зеленый» и «синий», и мы также можем назначать цвета, набирая их значения RGB в наших правилах. Значение RGB будет выглядеть так: rgb (255,0,0), где каждое число определяет, сколько из каждого цвета будет в конечном миксе.

Значения варьируются от 0 до 255, и в нашем примере мы видим, что только первое значение равно 255, а два других - равным 0. Это означает, что в нашем значении есть только красный цвет, а соответствующий элемент будет окрашен в красный цвет. Значение RGB (0, 0, 0) даст черный цвет, а значение (255, 255, 255) даст белый цвет.

Невозможно попытаться запомнить каждый цветовой код и по этой причине есть множество инструментов онлайн для выбора цветов, которые вы хотите для своих проектов. Например: https://www.w3schools.com/colors/colors\_picker.asp или http://htmlcolorcodes.com/color-picker/.

```css
p { 
  color: rgb(0, 255, 0); 
 } 
```

Это правило изменяет цвет шрифта всех p элементов на зеленый, как указано выше.

### Шестнадцатеричные значения

Шестнадцатеричные значения - еще один способ определить цвета в CSS, и они работают аналогично значениям RGB.

Случайному шестнадцатеричному коду было бы так: `#29432b` , где первые два символа после хеш-позиции составляют количество RED в миксе, а второе второе - количество зеленого, а последние два - на количество синего.

Значения `#000000` и `#ffffff` обозначают соответственно черный и белый. Вы можете найти конкретные шестнадцатеричные цвета, которые вам нужны, используя те же инструменты, что и для значений RGB.

### Синтаксис
```
p { 
  color: #00fe00; 
 } 
```

Это правило снова изменяет цвет шрифта всех p элементов на зеленый.

### HSL

HSL имеет три значения. Первый - это **оттенок,** который является мерой в градусах. Таким образом, 0 (или 360) представляет цвет красный, на 120 он зеленый, а 240 - синий. Второй - это **насыщенность,** которая имеет процентное значение в диапазоне от 0 до 100%. Третий - это **Lightness,** который также имеет процентное значение в диапазоне от 0 до 100%. 0% темно-черный, 50% средний, 100% белый.

### Синтаксис
```
p { 
  color: hsl(0, 100%, 50%); 
 } 
```

### Вывод

[JSfiddle](https://jsfiddle.net/qcw2n145/)

### Зачем использовать значения RGB или HEX?

Названия цветов принимают только 140 значений, тогда как значения RGB и HEX имеют 16 777 216 возможных комбинаций. Поэтому, если вы хотите, чтобы ваши проекты выглядели точно так, как вы их предполагали, вы должны использовать два последних варианта и сохранять значения имен цветов для макетов и целей тестирования.

#### Дополнительная информация:

[w3schools](https://www.w3schools.com/colors/default.asp)

[W3 Проектная документация](https://drafts.csswg.org/css-color-3/#color)

[MDN | Цвета CSS](https://developer.mozilla.org/en-US/docs/Web/CSS/color)