---
title: CSS3 Flexible Box
localeTitle: CSS3 Flexible Box
---
## CSS3 Flexible Box

Модель Flexbox обеспечивает эффективный способ компоновки, выравнивания и распределения пространства среди элементов вашего документа - даже если видовой экран и размер ваших элементов являются динамическими или неизвестными.

Самая важная идея модели Flexbox заключается в том, что родительский контейнер может изменять ширину / высоту / порядок своих элементов, чтобы наилучшим образом заполнить доступное пространство. Гибкий контейнер расширяет элементы для заполнения свободного места или сжимает их, чтобы предотвратить переполнение. 1

#### Основное использование

Flexbox можно использовать для центрирования любого количества заданных элементов внутри одного элемента. Основным примером этого является следующий код:

`css .center-elements-inside { display: flex; flex-direction: row; justify-content: center; }`

Давайте разберем этот пример. Сначала мы устанавливаем свойство display «flex», чтобы мы могли применить наши свойства flexbox. Затем мы объявляем, как flexbox будет обрабатывать наши элементы. Это может быть либо в строке, либо в столбце. Установка его в строке приведет к выравниванию элементов, расположенных внутри элемента. Столбец будет выравнивать их по вертикали.

Теперь давайте коротко взглянем на «justify-content». Это свойство объявляет, как элементы распределяются внутри родительского элемента. Мы выбрали значение «центра». Это означает, что все элементы внутри этого элемента будут центрированы.

#### Дополнительная информация:

Чтобы получить полное представление о Flexbox, прочитайте « [Понимание Flexbox». Все, что вам нужно знать](https://medium.freecodecamp.org/understanding-flexbox-everything-you-need-to-know-b4013d4dc9af) на странице FreeCodeCamp Medium.

Для интерактивного руководства перейдите в [The Ultimate Guide to Flexbox - Изучение примеров](https://medium.freecodecamp.org/the-ultimate-guide-to-flexbox-learning-through-examples-8c90248d4676)

Оба они являются прекрасными ресурсами Охана Эммануэля.

Еще одно замечательное визуальное руководство, которое является глубоким, но простым в использовании, можно найти в [«Руководстве по Flexbox» с](https://css-tricks.com/snippets/css/a-guide-to-flexbox/) помощью [CSS-Tricks](https://css-tricks.com)

### источники

1.  [Койер, Крис. «Полное руководство по Flexbox» CSS-Tricks. Последнее обновление: 28 сентября 2017 года.](https://css-tricks.com/snippets/css/a-guide-to-flexbox/)