---
title: CSS3 Media Queries
localeTitle: Запросы мультимедиа CSS3
---
## Запросы мультимедиа CSS3

Медиа-запросы позволяют создавать разные стили для разных устройств / размеров экрана. Их введение в CSS3 значительно облегчило строительство чувствительных веб-страниц.

Лучший подход при разработке отзывчивого веб-сайта - сначала подумать о мобильном телефоне; это означает, что вы создаете свою страницу, начиная с дизайна и контента мобильной версии. Вы можете подумать, что с некоторыми масштабируемыми размерами (%, vw или vh) ваша страница отлично адаптируется к любому устройству. Но это не так. Может быть для некоторых очень простой дизайн, но, конечно, не для более распространенных или сложных страниц!

При разработке своей страницы для небольших устройств основное внимание будет уделено основному контенту. На большом экране вам нужно будет прочитать некоторые размеры шрифта, поля, paddings и т. д., чтобы ваш сайт был удобным и удобочитаемым, но вы также захотите / хотите добавить больше контента, те, которые вы не судили и заполнить пространство, созданное размером экрана.

Мыслительный процесс должен быть:

1.  Какой контент показывать?
2.  Как сделать макет?
3.  Размер?

### Основной синтаксис

```css
    @media only screen and (min-width: 768px) { 
      p {padding: 30px;} 
    } 
```

Тэг `p` будет иметь отступы 30px, как только экран достигнет ширины min 768px.

### Синтаксис И

```css
  @media only screen and (min-height: 768px) and (orientation: landscape) { 
    p {padding: 30px;} 
  } 
```

Тэг `p` будет иметь отступы 30px, как только экран достигнет высоты 768px, а его ориентация будет ландшафтной.

### Синтаксис OR

```css
    @media only screen and (min-width: 768px), (min-resolution: 150dpi) { 
      p {padding: 30px;} 
    } 
```

Тэг `p` будет иметь отступы 30px, как только экран достигнет минимальной ширины 768 пикселей или его разрешение достигнет min 150dpi.

### Больше информации

*   [MDN - медиа-запросы](https://developer.mozilla.org/en-US/docs/Web/CSS/Media_Queries/Using_media_queries)
*   [Школы W3 - правило @media](https://www.w3schools.com/cssref/css3_pr_mediaquery.asp)
*   [CSS Tricks Стандартные размеры устройств Atricle](https://css-tricks.com/snippets/css/media-queries-for-standard-devices/)
*   \[https://alistapart.com/article/responsive-web-design\](Ethan Marcotte A List Apart Atricle на отзывчивом веб-дизайне)