---
title: Fonts
localeTitle: Шрифты
---
## Шрифты

Свойства шрифта CSS определяют семейство шрифтов, вес, размер, вариант, высоту строки и стиль текста.

### Семейство шрифтов

Семейство шрифтов текста просто устанавливается с использованием свойства `font-family` .

Он работает с _резервной_ системой, если ваш браузер не поддерживает первый шрифт, он пытается со следующим и так далее. Если имя шрифта более одного слова, оно должно быть окружено кавычками.

```css
p { 
    font-family: "Times New Roman", Times, serif; 
 } 
```

В приведенном выше примере «Times New Roman» является шрифта, а «serif» - это , В качестве резервной копии используются общие имена механизм сохранения стиля, если фамилия недоступна. Общее имя всегда должно быть последним элементом в списке имен семейств шрифтов. общий фамилии - засечка, без засечек, моноширины, скоропись, фэнтези, система-ui.

### Стиль шрифта

Свойство `font-style` можно использовать для указания курсивного текста.

Это свойство имеет 3 значения:

*   normal - текст отображается нормально
*   курсив - текст, _выделенный курсивом_
*   наклонный - текст показан наклонным

```css
.normal { 
    font-style: normal; 
 } 
 
 .italic { 
    font-style: italic; 
 } 
 
 .oblique { 
    font-style: oblique; 
 } 
```

### Размер шрифта

Свойство `font-size` задает размер текста.

Существуют различные типы значений размера шрифта:

*   `px` (pixels) - размер текста по умолчанию `16px`
*   `em` - `1em` = текущий размер шрифта, поэтому `1em` = `16px` (рекомендуется W3C)
*   `small` , `medium` , `large` - известные как абсолютные величины
*   `%` - проценты

```css
.with-pixels { 
    font-size: 14px; 
 } 
 
 .with-ems { 
    font-size: 0.875em; 
 } 
 
 .with-absolute { 
    font-size: large; 
 } 
 
 .with-percentage { 
    font-size: 80%; 
 } 
```

### Вес шрифта

Свойство `font-weight` определяет вес (или смелость) шрифта. Принимает ключевые слова ( `bold` , `normal` , `bolder` , `lighter` ) или числовые ключевые слова ( `100` , `200` , `300` , `400` и т. Д.). `400` - это то же самое, что и в `normal` .

```css
p { 
   font-weight: bold 
 } 
```

Для отптимизации CSS используют вариант сокращенной записи

```css
font: italic small-caps lighter 14px Georgia, serif;
```

### Отзывчивость шрифта

Размер текста можно установить с помощью блока vw (ширина видового экрана). Таким образом, размер текста будет соответствовать размеру окна браузера.

```html
<h1 style="font-size:10vw">Hello World</h1> 
```

`Viewport is the browser window size. 1vw = 1% of viewport width. If the viewport is 50cm wide, 1vw is 0.5cm.`

### Вариант шрифта

Свойство `font-variant` указывает, должен ли текст отображаться в шрифте с малыми шапками (где все строчные буквы преобразуются в прописные буквы, причем они отображаются в меньшем размере шрифта, чем оригинальные заглавные буквы в тексте).

```css
p.small { 
  font-variant: small-caps; 
 } 
```

#### Дополнительная информация:

*   [Школы W3 - Шрифт CSS](https://www.w3schools.com/css/css_font.asp)
*   [MND - CSS-шрифт](https://developer.mozilla.org/en-US/docs/Web/CSS/font)
*   [CSSFontStack](https://www.cssfontstack.com/)
