---
title: Forms
localeTitle: формы
---
## формы

Элемент HTML Form определяет форму, которая используется для сбора пользовательского ввода. Примеры:

```html

<form> 
  contents 
 </form> 
```

HTML-форма содержит элементы формы.

Элементы формы - это разные типы элементов ввода, такие как текстовые поля, флажки, переключатели, кнопки отправки и т. Д.


Внутри тегов формы есть также 2 важных атрибута:
 **action** содержит адрес, который определяет, куда будет отправлена информация формы;
 **method** может быть либо GET, либо POST и определяет, как будет отправлена информация формы.

Элемент <fieldset></fieldset> используется для группировки элементов, связанных друг с другом, разделяя форму на логические фрагменты.

Большинство полей формы создает элемент <input> . Атрибуты элемента отличаются в зависимости от типа поля, для создания которого используется этот элемент.

Атрибуты тега input:

accept - Определяет тип файла, разрешенных для отправки на сервер. Указывается только для <input type="file">. Возможные значения:
file_extension — разрешает загрузку файлов с указанным расширением, например, accept=".gif", accept=".pdf", accept=".doc"
audio/* — разрешает загрузку аудиофайлов
video/* — разрешает загрузку видеофайлов
image/* — разрешает загрузку изображений
media_type — указывает на медиа-тип загружаемых файлов.

alt	- Определяет альтернативный текст для изображений, указывается только для <input type="image">.

autocomplete	Отвечает за запоминание введенных в текстовое поле значений и автоподстановку их при последующем вводе:
on — означает, что поле не защищено, и его значение можно сохранять и извлекать,
off — отключает автозаполнение для полей форм.

autofocus	Позволяет сделать так, чтобы в загружаемой форме то или иное поле ввода уже имело фокус (было выбрано), являясь готовым к вводу значения.

checked	Атрибут проверяет, установлен ли флажок по умолчанию при загрузке страницы для полей типа type="checkbox" и type="radio".

disabled	Отключает возможность редактирования и копирования содержимого поля.

form	Значение атрибута должно быть равно атрибуту id элемента <form> в этом же документе. Определяет одну или несколько форм, которым принадлежит данное поле формы.
  
formaction	Задает url файла, который будет обрабатывать введенные в поля данные при отправке формы. Задается только для полей типа type="submit" и type="image". Атрибут переопределяет значение атрибута action самой формы.

height	Значение атрибута содержит количество пикселей без указания единицы измерения. Устанавливает высоту поля формы типа type="image", например, <input type="image" src="img_submit.gif" height="50">. Рекомендуется одновременно устанавливать как высоту, так и ширину поля.

list	Является ссылкой на элемент <datalist>, содержит его id.Позволяет предоставить пользователю несколько вариантов на выбор, когда он начинает вводить значение в соответствующем поле.
  
max	Позволяет ограничить допустимый ввод числовых данных максимальным значением, значение атрибута может содержать целое или дробное число. Рекомендуется использовать этот атрибут вместе с атрибутом min. Работает со следующими типами полей: number, range, date, datetime, datetime-local, month, time и week

maxlength	Атрибут задает максимальное количество символов, вводимых в поле. Значение по умолчанию 524288 символов.

min	Позволяет ограничить допустимый ввод числовых данных минимальным значением.

multiple	Позволяет пользователю ввести несколько значений атрибутов, разделяя их запятой. Применяется в отношении файлов и адресов электронной почты. Указывается без значения атрибута.

name	Определяет имя, которое будет использоваться для доступа к элементу <form>, к примеру, в таблицах стилей css. Является аналогом атрибута id.
  
placeholder	Содержит текст, который отображается в поле ввода до заполнения (чаще всего это подсказка).

readonly	Не позволяет пользователю изменять значения элементов формы, выделение и копирование текста при этом доступно. Указывается без значения атрибута.

required	Выводит сообщение о том, что данное поле является обязательным для заполнения. Если пользователь попытается отправить форму, не введя в это поле требуемое значение, то на экране отобразится предупреждающее сообщение. Указывается без значения атрибута.

size	Задает видимую ширину поля в символах. Значение по умолчанию — 20. Работает со следующими типами полей: text, search, tel, url, email и password.

src	Задает url изображения, используемого в качестве кнопки отправки данных формы. Указывается только для поля <input type="image">.

step	Используется для элементов, предполагающих ввод числовых значений, указывает величину увеличения или уменьшения значений в процессе регулировки диапазона (шаг).

type - button — создает кнопку.
checkbox — превращает поле ввода во флажок, который можно установить или очистить.

color — генерирует палитры цветов в поддерживающих браузерах, давая пользователям возможность выбирать значения цветов в шестнадцатеричном формате.

date — позволяет вводить дату в формате дд.мм.гггг.

datetime-local — позволяет вводить дату и время, разделенные прописной английской буквой Т по шаблону дд.мм.гггг чч:мм.

email — браузеры, поддерживающие данный атрибут, будут ожидать, что пользователь введет данные, соответствующие синтаксису адресов электронной почты.
E-mail: 
file — позволяет загружать файлы с компьютера пользователя.

hidden — скрывает элемент управления, который не отображается браузером и не дает пользователю изменять значения по умолчанию.
image — создает кнопку, позволяя вместо текста на кнопке вставить изображение.

Submit
month — позволяет пользователю вводить год и номер месяца по шаблону гггг-мм.

number — предназначено для ввода целочисленных значений. Его атрибуты min, max и step задают верхний, нижний пределы и шаг между значениями соответственно. Эти атрибуты предполагаются у всех элементов, имеющих численные показатели. Их значения по умолчанию зависят от типа элемента.

password — создает текстовые поля в форме, при этом вводимые пользователем символы заменяются на звездочки, маркеры, либо другие, установленные браузером значки.

radio — создает переключатель — элемент управления в виде небольшого кружка, который можно включить или выключить.
 
range — позволит создать такой элемент интерфейса, как ползунок, min / max — позволят установить диапазон выбора 
reset — создает кнопку, которая очищает поля формы от введенных пользователем данных.
search — обозначает поле поиска, по умолчанию поле ввода имеет прямоугольную форму.

submit — создает стандартную кнопку, активизируемую щелчком мыши. Кнопка собирает информацию с формы и отправляет ее для обработки.
text — создает текстовые поля в форме, выводя однострочное текстовое поле для ввода текста.

time — позволяет вводить время в 24-часовом формате по шаблону чч:мм. В поддерживающих браузерах оно отображается как элемент управления в виде числового поля ввода со значением, изменяемым с помощью мыши, и допускает ввод только значений времени.

url — поле предназначено для указания URL-адресов.

week — соответствующий инструмент-указатель позволяет пользователю выбрать одну неделю в году, после чего обеспечит ввод данных в формате нн-гггг. В зависимости от года число недель может быть 52 или 53.
Укажите неделю: 

value	Определяет текст, отображаемый на кнопке, в поле или связанный текст. Не указывается для полей типа file.

width	Значение атрибута содержит количество пикселей. Позволяет задать ширину полей формы.

Кнопки.
Элемент <button></button> создает кликабельные кнопки. В отличие от кнопок, созданных <input> (<input type="submit"></input>, <input type="image">, <input type="reset">, <input type="button">), внутрь элемента <button> можно поместить контент — текст или изображение.

Для корректного отображения элемента <button> разными браузерами нужно указывать атрибут type, например, <button type="submit"></button>.

Кнопки позволяют пользователям передавать данные в форму, очищать содержимое формы или предпринимать какие-либо другие действия. Можно создавать границы, изменять фон и выравнивать текст на кнопке.

Флажки и переключатели в формах.
Флажки в формах задаются с помощью конструкции <input type="checkbox">, а переключатель — при помощи <input type="radio">.

Флажков, в отличие от переключателей, в одной форме может быть установлено несколько. Если для флажков указан атрибут checked, то при загрузке станицы на соответствующих полях формы флажки уже будут установлены.
