---
title: Height and Width Dimensions
localeTitle: Высота и ширина Размеры
---
## Высота и ширина Размеры

### Определение

Программисты могут использовать свойства высоты и ширины для изменения высоты и ширины конкретных элементов. Чтобы их размеры были изменены, значение свойства `display` этих элементов должно быть установлено на `block` или `inline-block` .

### Синтаксис

#### Высота:

*   `height: auto|length|initial|inherit;`
*   `min-height: length|initial|inherit;`
*   `max-height: none|length|initial|inherit;`

#### Ширина:

*   `width: auto|value|initial|inherit;`
*   `min-width: length|initial|inherit;`
*   `max-width: none|length|initial|inherit;`

### Использование и примеры

Все упомянутые выше свойства могут иметь только **одно** значение.

#### Высота:

Свойство `height` задает точную высоту элемента. Значение `auto` является значением по умолчанию и позволяет браузеру автоматически устанавливать высоту. Обычно это определяется тем, сколько вертикального пространства занимает элемент элемента. Длина высоты может быть установлена ​​в `px` отношению к высоте ближайшего родительского элемента с использованием единицы `%` или относительно высоты `vh` просмотра с помощью модуля `vh` . `initial` значение будет иметь тот же эффект, что и `auto` значение в то время как в `inherit` значение даст элементу ту же высоту, что и его ближайший родительский элемента.

**Пример:**

```html

<p id="red">Example text</p> 
```

```css
p#red { 
    margin: 0; 
  background-color: red; 
  height: 50vh; 
    line-height: 50vh; 
    text-align:center; 
 } 
```

**Результат:** ![Пример 1](https://image.prntscr.com/image/dbKSQofTThGZRD7FJLyjJQ.png) В приведенном выше примере используется единица `vh` для установки высоты. Этот блок используется для установки высоты элемента относительно высоты окна просмотра. В этом случае красной абзаце присваивается высота половины высоты видового экрана, поэтому она занимает 50% экрана. _Примечание. Все поля по умолчанию должны быть удалены из тела, чтобы результат выглядел как следует._

Свойство `min-height` устанавливает минимальную высоту, которую должен иметь элемент. Это свойство полезно при вертикальном изменении размера страницы, так как программист может помешать слишком большому элементу и не появиться. Значение по умолчанию для `min-height` элемента равно 0. Код CSS, приведенный ниже, не позволит абзацу с `ID` **примера** сокращаться до высоты менее 400 пикселей.

**Пример:**

```css
p#example { 
  min-height: 400px; 
 } 
```

Свойство `max-height` устанавливает максимальную высоту, которую может достигнуть элемент. Это может быть полезно, если вы не хотите, чтобы элемент был больше определенного размера. Если содержимое элемента имеет большую высоту, чем значение `max-height` , содержимое будет переполняться.

**Пример:**

```css
p { 
  max-height: 40px; 
  background-color: red; 
 } 
```

**Результат:** ![Пример 3.](https://image.prntscr.com/image/eRdqazdUSWO2rdVfcUb5rQ.png)

#### Ширина:

Объяснения свойств ширины CSS точно такие же, как и свойства высоты, за исключением того, что они изменяют ширину элемента. Поэтому я покажу несколько примеров использования этих свойств ниже.

**Пример:**

```css
p { 
  width: 150px; 
  background-color: red; 
 } 
```

**Результат:** ![Пример 4.](https://image.prntscr.com/image/x1_khU6TQsmZQznt7YU9qw.png)

_Примечание. Содержимое не переполняется вправо, оно занимает только указанную ширину и затем разбивается на следующую строку._

**Пример:**

```css
p { 
  min-width: 50px; 
 } 
```

Приведенный выше код просто не позволит элементу абзаца сжиматься горизонтально до менее 50 пикселей.

**Пример:**

```css
p { 
  max-width: 300px; 
  background-color: red; 
 } 
```

Приведенный выше код не позволит ширине элемента больше 300 пикселей.

Я надеюсь, что эта статья поможет вам получить удобные размеры и ширину CSS. Я добавил некоторые ссылки ниже, если вы хотите больше узнать об этих свойствах.

#### Дополнительная информация:

*   Размеры и ширина CSS: https://www.w3schools.com/css/css\_dimension.asp
*   Свойство высоты CSS: https://www.w3schools.com/cssref/pr _dim_ height.asp
*   Свойство ширины CSS: https://css-tricks.com/almanac/properties/w/width/
*   Длина CSS: https://developer.mozilla.org/en-US/docs/Web/CSS/length