---
title: ID Selector
localeTitle: Выбор идентификатора
---
## Выбор идентификатора

Селектор идентификаторов CSS применяет стили к определенному элементу html. Селектор идентификаторов CSS должен соответствовать атрибуту ID элемента HTML. В отличие от классов, которые могут применяться к нескольким элементам на любом сайте, конкретный идентификатор может применяться только к одному элементу на сайте. Идентификатор CSS переопределяет свойства класса CSS. Чтобы выбрать элемент с определенным идентификатором, напишите символ хеша (#), за которым следует идентификатор элемента.

### Синтаксис

```css
#specified_id { /* styles */ } 
```

Вы можете комбинировать селектор идентификаторов с другими типами селекторов для создания особого элемента.

```css
section#about:hover { color: blue; } 
 
 div.classname#specified_id { color: green; } 
```

### Примечание о идентификаторах

ID следует избегать при стилизации, если это возможно. Поскольку он обладает высокой специфичностью и его можно переопределить только в том случае, если вы встраиваете стили или добавляете стили в `<style>` . Вес ID переопределяет селектора классов и селекторов типов.

Помните, что идентификатор должен соответствовать атрибуту ID элемента HTML.

```html

<div id="specified_id"><!-- content --></div> 
```

### специфичность

Селекторы ID имеют высокую специфичность, что затрудняет их переопределение. Классы имеют гораздо более низкую специфичность и обычно являются предпочтительным способом стилизации элементов, чтобы избежать проблем с конкретностью. [Специфичность для MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/Specificity)

#### Дополнительная информация:

[freeCodeCamp Challenge - установка идентификатора элемента](https://www.freecodecamp.org/challenges/set-the-id-of-an-element)

[freeCodeCamp Challenge - использовать атрибут идентификатора для стилизации элемента](https://www.freecodecamp.org/challenges/use-an-id-attribute-to-style-an-element)

[MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/ID_selectors)