---
title: Display Property
localeTitle: Показать свойство
---
## Показать свойство

Свойство `display` указывает тип поля, используемого для элемента HTML. Всего 20 основных значений ключевых слов, хотя обычно используется только 10. Обычно используются:

```css
.none           {display: none} 
 .block          {display: block} 
 .inline-block   {display: inline-block} 
 .inline         {display: inline} 
 .flex           {display: flex} 
 .inline-flex    {display: inline-flex} 
 .inline-table   {display: inline-table} 
 .table          {display: table} 
 .inherit        {display: inherit} 
 .initial        {display: initial} 
```

**Общие примеры:**

```css
.myBox { 
    display: block; 
 } 
 
 .myContainer { 
    display: flex; 
 } 
 
 .inlineList ul > li { 
    display: inline; 
 } 
```

#### Дополнительная информация:

*   Документация и полный список значений ключевых слов: [MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/display)
    
*   Ссылка W3Schools CSS на свойство отображения доступна: [W3Schools](https://www.w3schools.com/cssref/pr_class_display.asp)
    
*   CSS-TRICKS имеет отличную ссылку на свойство отображения: [CSS-Tricks](https://css-tricks.com/almanac/properties/d/display/)
    
*   Поддержка браузера: [caniuse](http://caniuse.com/#search=display)
    
*   Полное руководство по Flexbox: [CSS-Tricks](https://css-tricks.com/snippets/css/a-guide-to-flexbox/)