---
title: Flexbox
localeTitle: Flexbox
---
## Flexbox

Flexbox - это новый способ структурирования контента в CSS3. Это отличный способ создать отзывчивые веб-сайты, которые хорошо работают с различными размерами экрана и содержимым заказа.

Существует три простых способа использования flexbox.

1.  Преобразование родительского контейнера в гибкий контейнер с помощью _display: flex;_ в разделе css
2.  Отрегулируйте расположение различных контейнеров с использованием _гибкого направления_
3.  Отрегулируйте отдельные элементы, используя свойства, такие как justify-content, align-items и т. Д.

Платформа Flexbox нацелена на предоставление более эффективного способа выстраивания, выравнивания и распределения пространства между элементами в контейнере, даже когда их размер неизвестен и / или динамичен (таким образом, слово «flex»). Основная идея гибкой компоновки заключается в том, чтобы дать контейнеру возможность изменять ширину / высоту своих элементов (и порядок), чтобы наилучшим образом заполнить доступное пространство. ![flexUsage](https://cdn.css-tricks.com/wp-content/uploads/2011/08/flexbox.png)

*   **Основная ось** : Основная ось гибкого контейнера - это основная ось, вдоль которой выложены гибкие элементы. Остерегайтесь, это не обязательно горизонтально; это зависит от свойства flex-direction (см. ниже).
*   **главный запуск | main-end** Элементы flex размещаются внутри контейнера, начиная с основного запуска и заканчивая main-end.
:*   **Основной размер** : ширина или высота гибкого элемента, в зависимости от того, что находится в основном измерении, является основным размером элемента. Свойство основного размера элемента flex - это свойство «ширина» или «высота», в зависимости от того, что находится в основном измерении.
*   **поперечная ось** : ось, перпендикулярная основной оси, называется поперечной осью. Его направление зависит от направления основной оси.
*   **кросс-старт | кросс-конец** : линии Flex заполняются элементами и помещаются в контейнер, начиная со стороны поперечного начала гибкого контейнера и направляясь к стороне поперечного конца.
*   **cross size** : ширина или высота элемента гибкости, в зависимости от того, что находится в поперечном измерении, является поперечным размером элемента. Свойство кросс-размера имеет значение «ширина» или «высота», которое находится в поперечном измерении.

#### Дополнительная информация:

[Это отличная статья](https://medium.freecodecamp.org/an-animated-guide-to-flexbox-d280cf6afc35) для чтения, чтобы больше узнать о flexbox Это рекомендуемое практическое руководство, иллюстрирующее различные свойства гибкости, применяемые к гибкому контейнеру и гибким элементам: [https://css-tricks.com/snippets/css/a-guide-to-flexbox/](https://css-tricks.com/snippets/css/a-guide-to-flexbox/)