---
title: Legal Color Values
localeTitle: Юридические цветовые значения
---
## Юридические цветовые значения

Цвета в CSS можно указать в следующих форматах:

*   [шестнадцатеричный](#hexadecimal-colors)
*   [RGB](#rgb-colors)
*   [RGBA](#rgba-colors)
*   [HSL](#hsl-colors)
*   [HSLA](#hsla-colors)
*   [Предопределенные цветовые имена](#predefined-color-names)

### Шестнадцатеричные цвета

#### Поддержка браузера

Все основные браузеры поддерживают шестнадцатеричные цвета.

#### Формат

Шестнадцатеричное значение указывается как **#RRGGBB** , где шестнадцатеричные целые числа RR (красный), GG (зеленый) и BB (синий) задают компоненты цвета. Все значения должны быть между 00 и FF. Как следует из названия, кодирование находится в базе 16.

#### пример

Здесь представлены разные цвета. Найдите живой пример в https://jsfiddle.net/qg9revp4/2/.

```css
#divRed{ 
  color: #ff0000; /* red */ 
 } 
 
 #divGreen{ 
  color: #00ff00; /* green */ 
 } 
 
 #divBlue{ 
  color: #0000ff; /* blue */ 
 } 
 
 #divWhite{ 
  color: #ffffff; /* white */ 
  background: #000000; /* black background, so that the text is visible */ 
 } 
```

### Цвет RGB

#### Поддержка браузера

Все основные браузеры поддерживают значения RGB.

#### Формат

Значение RGB указано как **rgb (красный, зеленый, синий)** . Каждый параметр (красный, зеленый и синий) определяет интенсивность цвета и может быть целым числом от 0 до 255.

#### пример

Здесь представлены разные цвета RGB. Найдите живой пример на https://jsfiddle.net/vspepeth/1/.

```css
#divRed{ 
  color: rgb(255, 0, 0); /* red */ 
 } 
 
 #divGreen{ 
  color: rgb(0, 255, 0); /* green */ 
 } 
 
 #divBlue{ 
  color: rgb(0, 0, 255); /* blue */ 
 } 
 
 #divWhite{ 
  color: rgb(255, 255, 255); /* white */ 
  background: rgb(0, 0, 0); /* black background, so that the text is visible */ 
 } 
```

### Цвета RGBA

#### Поддержка браузера

Значения цвета RGBA поддерживаются в IE9 +, Firefox 3+, Chrome, Safari и в Opera 10+.

#### Формат

Значение RGBA указано как **rgb (красный, зеленый, синий, альфа)** . Подумайте об этом как о расширении формата RGB с альфа-каналом. Альфа-параметр представляет собой число от 0,0 (полностью прозрачное) и 1,0 (полностью непрозрачное). Другие параметры (красный, зеленый и синий) определяют интенсивность цветов и могут быть целыми от 0 до 255.

#### пример

Здесь представлены разные цвета RGBA. Найдите живой пример на https://jsfiddle.net/hq0ngwg2/1/.

```css
#divRed{ 
  color: rgba(255, 0, 0, 0.3); /* red with opacity */ 
 } 
 
 #divGreen{ 
  color: rgba(0, 255, 0, 0.7); /* green with opacity */ 
 } 
 
 #divBlue{ 
  color: rgba(0, 0, 255, 0.5); /* blue with opacity */ 
 } 
 
 #divWhite{ 
  color: rgba(255, 255, 255, 0.6); /* white with opacity */ 
  background: rgba(0, 0, 0, 0.8); /* black background with opacity */ 
 } 
```

### Цвета HSL

#### Поддержка браузера

Значения цветов HSL поддерживаются в IE9 +, Firefox, Chrome, Safari и в Opera 10+.

#### Формат

HSL обозначает оттенок, насыщенность и легкость. Он задается как **hsl (оттенок, насыщенность, легкость)** .

*   **Хюэ** : Это градус на цветовом колесе (от 0 до 360). _0_ (или _360_ ) красный, _120_ - зеленый, а _240_ - синий.
    
*   **Насыщенность** : это процентное значение. _0%_ означает оттенок серого, а _100%_ - полный цвет.
    
*   **Легкость** : это тоже процентное значение. _0%_ - черный, а _100%_ белый.
    

#### пример

Ниже приведены таблицы [W3.org](https://www.w3.org/TR/css3-color/#hsl-color) . Каждая таблица представляет один оттенок. Из цветового круга выбраны двенадцать одинаково разнесенных цветов (т. Е. С интервалом 30 °). Ось X каждой таблицы представляет собой насыщенность (100%, 75%, 50%, 25%, 0%). Ось Y представляет собой легкость. 50% «нормальный».

![Таблица HSL](https://image.ibb.co/ngq686/hsl.png)

Найдите живой пример на https://jsfiddle.net/g10zpL28/1/.

```css
#div1 { 
  background-color: hsl(240, 100%, 50%); /* blue */ 
 } 
 #div2 { 
  background-color: hsl(195, 53%, 79%); /* light blue */ 
 } 
 #div3 { 
  background-color: hsl(240, 100%, 25%); /* dark blue */ 
 } 
 #div4 { 
  background-color: hsl(187, 75%, 86%); /* pastel blue */ 
 } 
```

### Цвета HSLA

#### Поддержка браузера

Значения цветов HSLA поддерживаются в IE9 +, Firefox 3+, Chrome, Safari и в Opera 10+.

#### Формат

HSLA означает оттенок, насыщенность, легкость и альфа-канал. Он указан как **hsla (оттенок, насыщенность, легкость, альфа)** . Альфа-канал определяет непрозрачность цвета.

*   **Хюэ** : Это градус на цветовом колесе (от 0 до 360). _0_ (или _360_ ) красный, _120_ - зеленый, а _240_ - синий.
    
*   **Насыщенность** : это процентное значение. _0%_ означает оттенок серого, а _100%_ - полный цвет.
    
*   **Легкость** : это тоже процентное значение. _0%_ - черный, а _100%_ белый.
    
*   **Альфа-канал** : это число между 0.0 (полностью прозрачное) и 1.0 (полностью непрозрачное).
    

#### пример

Ниже приведены примеры цветов HSLA. Смотрите их на https://jsfiddle.net/2Lxscgfy/1/.

```css
#div1 { 
  background-color: hsla(240, 100%, 50%, 0.5); /* blue with transparency */ 
 } 
 #div2 { 
  background-color: hsla(195, 53%, 79%, 0.8); /* light blue with transparency */ 
 } 
 #div3 { 
  background-color: hsla(240, 100%, 25%, 0.3); /* dark blue with transparency */ 
 } 
 #div4 { 
  background-color: hsla(187, 75%, 86%, 1.0); /* pastel blue with transparency */ 
 } 
```

### Предопределенные цветовые имена

#### Поддержка браузера

147 названий цветов предопределены в спецификации цвета CSS. Все современные браузеры поддерживают их.

#### пример

Ниже приведены несколько названий цветов. Просмотрите пример в реальном времени на странице https://jsfiddle.net/rqygumpy/. Найдите весь список в [Документах MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/color_value#Color_keywords) .

```css
#div1{ 
  color: BlueViolet; 
 } 
 
 #div2{ 
  color: RebeccaPurple; 
 } 
 
 #div3{ 
  color: RoyalBlue; 
 } 
 
 #div4{ 
  color: Salmon; 
 } 
```

#### Дополнительная информация:

[MDN Web Docs на цветах CSS](https://developer.mozilla.org/en-US/docs/Web/CSS/color)