---
title: Margins
localeTitle: Внешние отступы
---
# Внешние отступы

Свойство CSS `margin` задаёт внешние отступы со всех четырёх сторон элемента. Это свойство можно использовать для создания пространства вокруг содержимого (за пределами границы). Это сокращённая запись для того, чтобы сразу установить все индивидуальные внешние отступы: `margin-top`, `margin-right`, `margin-bottom` и `margin-left`. Значения определяются по часовой стрелке. Можно легко запомнить аббревиатуру T - top, R - right, B - bottom, L - left (TRBL), как слово `trouble`.


Значения внешнего отступа устанавливаются с помощью длины или процентов или ключевого слова `auto` или `inherit` и могут принимать нулевые или отрицательные значения. Начальное значение или значение по умолчанию для всех свойств внешнего отступа равно 0. В то время как вы можете использовать ключевое слово `inherit`, но оно не может быть использовано вместе со значением длины.


## Синтаксис
```css
.element {
    margin: margin-top || margin-right || margin-bottom || margin-left;
}
```

Это свойство может быть задано с помощью одного, двух, трех или четырех значений.
* Когда задано одно значение, применяется один и тот же внешний отступ ко всем четырем сторонам элемента.
* При указании двух значений, первый внешний отступ применяется к верхней и нижней стороне элемента, второй — к левой и правой.
* Когда заданы три значения, первый внешний отступ применяется к верхней стороне элемента, второй — к левой и правой, третий — к нижней.
* При указании четырех значений, внешний отступ применяется к верхней, правой, нижней и левой стороне элемента в указанном порядке (по часовой стрелке).

```css
/* Применяется ко всем четырём сторонам элемента */
margin: 1em;
  
/* сверху и снизу | слева и справа */
margin: 5% 10%;
  
/* сверху | слева и справа | снизу */
margin: 1em 2em 2em;

/* сверху | справа | снизу | слева */
margin: 5px 1em 0 1em;
```

## Где используется в блочной модели документа
Свойство `margin` в CSS определяет внешнюю часть блочной модели документа, создавая пространство вокруг содержимого элемента, за пределами любых заданных внутренних отступов и/или границ.

![Блочная модель документа](https://www.w3.org/TR/CSS2/images/boxdim.png "Диаграмма блочной модели документа")

## Схлопывание внешних отступов
Вертикальные внешние отступы на разных элементах, которые соприкасаются друг с другом (таким образом что, не имеют содержимого, внутренних отступов или границ, разделяющих их), будут схлопнуты, образуя один внешний отступ, равный наибольшему внешнему отступу из примыкающих. Это не сработает с горизонтальными внешними отступами (слева и справа), а только с вертикальными (сверху и снизу).

## Поддержка броузерами
Это отлично поддерживается всеми броузерами (начиная с IE6+, Firefox 2+, Chrome 1+ и т. д.)


### Подробная информация
* [W3C Working Draft](https://www.w3.org/TR/css3-box/#the-margin)
* [W3C CSS Level 2](https://www.w3.org/TR/CSS2/box.html#propdef-margin)
* [W3C CSS Level 1](https://www.w3.org/TR/CSS1/#margin)
* [MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/CSS/margin)
* [CSS Tricks](https://css-tricks.com/almanac/properties/m/margin/)

