---
title: Overflow
localeTitle: перелив
---
# перелив

Свойство `overflow` указывает, что произойдет, если содержимое переполняет поле элемента (это свойство работает только для элементов блока с указанной высотой).

Это свойство указывает, следует ли клип-контент или добавлять полосы прокрутки, когда содержимое элемента слишком велико, чтобы вписаться в указанную область.

Например, заданный элемент уровня блока ( `<div>` ), установленный на ширину 300 пикселей, содержит изображение шириной 400 пикселей. Изображение будет выходить из div и быть видимым по умолчанию. Однако, если значение переполнения установлено в скрытое, изображение будет отключено на 300 пикселей.

## Значения

*   `visible` : Это значение по умолчанию для свойства. Содержимое не обрезается, если оно больше, чем поле.
*   `hidden` : переполненное содержимое будет скрыто.
*   `scroll` : похоже на скрытый, но пользователи смогут прокручивать скрытый контент.
*   `auto` : Если содержимое выходит за пределы его поля, то это содержимое будет скрыто, в то время как полоса прокрутки должна быть видимой для пользователей, чтобы прочитать остальную часть содержимого.
*   `initial` : Использует значение по умолчанию, которое видно.
*   `inherit` : Устанавливает переполнение для значения его родительского элемента.

## Примеры

### Видимых:

```css
.box-element { overflow: visible; } 
```

![Пример изображения](https://s26.postimg.org/gweu6g5yh/1-vissible.png)

### Скрытые:

```css
.box-element { overflow: hidden; } 
```

![Пример изображения](https://s26.postimg.org/l49mf77e1/2-hidden.png)

### Прокрутка:

```css
.box-element { overflow: scroll; } 
```

![Пример изображения](https://s26.postimg.org/d8z30dxrd/3-scroll.png)

### Авто:

```css
.box-element { overflow: auto; } 
```

![Пример изображения](https://s26.postimg.org/z5q7ei0bt/4-autoank.png)

## переполнение-x и переполнение-y

*   `overflow-x` : позволяет пользователю прокручивать содержимое, которое выходит за пределы высоты элемента box.
*   `overflow-y` : позволяет пользователю прокручивать содержимое, выходящее за пределы ширины окна.

```css
  .box-element { 
    overflow-x: scroll; 
    overflow-y: auto; 
  } 
```

`.box-element` будет выглядеть так: ![Пример изображения](https://s26.postimg.org/ff2kmdfzd/5-_Xand_Y.png)

Если содержимое переполняет ось Y, то это содержимое будет скрыто, в то время как полоса прокрутки должна быть видимой для пользователей, чтобы прочитать остальную часть содержимого.

#### Дополнительная информация:

CSS-трюки: [переполнение](https://css-tricks.com/almanac/properties/o/overflow/)