---
title: Padding
localeTitle: Отступ
---
# Отступ

Свойство `padding` CSS задает область заполнения на всех четырех сторонах элемента. Это свойство может использоваться для создания пространства вокруг контента (внутри границы). Это краткое описание, чтобы установить все отдельные paddings сразу: `padding-top` , `padding-right` , `padding-bottom` и `padding-left` . Значения определяются по часовой стрелке.

Значения заполнения задаются с использованием длин или процентов или `inherit` ключевое слово и не могут принимать отрицательные значения. Начальная, или по умолчанию, значение для всех свойств заполнения 0. В то время как вы можете использовать `inherit` ключевое слово , но оно не может быть использовано вместе со значением длины.

## Синтаксис

```css
.element { 
    padding: [padding-top] || [padding-right] || [padding-bottom] || [padding-left]; 
 } 
```

Это свойство может быть указано с использованием одного, двух, трех или четырех значений.

*   Когда задано одно значение, он применяет одинаковое дополнение ко всем четырем сторонам.
*   Когда указаны два значения, первое дополнение применяется к верхнему и нижнему, второе - к левому и правому.
*   Когда указаны три значения, первое дополнение применяется к верхней части, вторая - к левой и правой, третья - к нижней.
*   Когда указаны четыре значения, прокладки применяются к верхнему, правому, нижнему и левому в этом порядке (по часовой стрелке).

```css
/* em refers to the current font size of an element */ 
 /* Apply to all four sides */ 
 padding: 1em; 
 
 /* top and bottom | left and right */ 
 padding: 5% 10%; 
 
 /* top | left and right | bottom */ 
 padding: 1em 2em 2em; 
 
 /* top | right | bottom | left */ 
 padding: 5px 1em 0 1em; 
```

## Где в коробке

Свойство прокладки в CSS определяет самую внутреннюю часть модели окна, создавая пространство вокруг содержимого элемента внутри любых определенных полей и / или границ.

  * ![Модель CSS Box](http://htmlbook.ru/files/images/css/css_padding_1.png)

## Поддержка браузера

Он эффективно поддерживается во всех браузерах (с IE6 +, Firefox 2+, Chrome 1+ и т. Д.),

### Больше информации

*   [Рабочий проект W3C](https://www.w3.org/TR/css3-box/#the-padding)
*   [W3C CSS Level 2](https://www.w3.org/TR/CSS2/box.html#propdef-padding)
*   [W3C CSS Уровень 1](https://www.w3.org/TR/CSS1/#padding)
*   [Веб-документы MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/padding)
*   [Трюки CSS](https://css-tricks.com/almanac/properties/p/padding/)
*   [CSS на русском языке](http://htmlbook.ru/css/padding)
