---
title: Background Repeat Property
localeTitle: Фон Повторить свойство
---
## Фон Повторить свойство

Свойство background-repeat CSS определяет, как повторяются фоновые изображения.

Фоновое изображение может повторяться вдоль горизонтальной оси, вертикальной оси, обеих осей или вообще не повторяться. По умолчанию фоновое изображение повторяется как по вертикали, так и по горизонтали.

Синтаксис:

```css
background-repeat: repeat|repeat-x|repeat-y|no-repeat|initial|inherit; 
```

*   repeat: фоновое изображение будет повторяться как по вертикали, так и по горизонтали. Это значение по умолчанию
    
*   repeat-x: фоновое изображение будет повторяться только горизонтально
    
*   repeat-y: фоновое изображение будет повторяться только вертикально.
    
*   no-repeat: фоновое изображение не будет повторяться.
    
*   initial: Устанавливает это свойство по умолчанию.
    
*   inherit: Наследует это свойство от его родительского элемента.
    

Примеры: Для повторения изображения как по горизонтали, так и по вертикали

```css
body { 
    background-image:url(smiley.gif); 
    background-repeat:repeat; 
 } 
```

Для повторения изображения по горизонтали

```css
body { 
    background-image:url(smiley.gif); 
    background-repeat:repeat-x; 
 } 
```

#### Дополнительная информация:

[Для получения дополнительной информации о свойствах повтора фона](https://developer.mozilla.org/en-US/docs/Web/CSS/background-repeat)