---
title: Color Property
localeTitle: Цветная собственность
---
## Свойство цвета CSS

Вы можете использовать свойство `color` для установки цвета текста в элементе.

Вы можете использовать несколько методов для объявления цвета, например:

*   По имени (Примечание: это работает только с определенными цветами)

```css
h1{ 
    color: blue; 
 } 
```

*   Шестнадцатеричный (указанный как #rrggbb)

```css
h1{ 
    color:  #0000ff; 
 } 
```

*   RGB (указано как rgb (r, g, b))

```css
h1{ 
    color: rgb(0, 0, 255); 
 } 
```

*   RGBA (определяется как rgba (r, g, b, alpha))

```css
h1{ 
    color: rgba(0, 0, 255, 0.5); 
 } 
```

*   HSL (оттенок, легкость, насыщенность)

```css
h1{ 
    color: hsl(240, 100%, 50%); 
 } 
```

*   HSLA (оттенок, легкость, насыщенность, альфа)

```css
h1{ 
    color: hsl(240, 100%, 50%, 0.5); 
 } 
```

## Свойства цвета CSS объяснены

*   Цвета по имени:
    
    *   Они довольно понятны. Каждый цвет представлен его именем.
*   Hexadecimal:
    
    *   Эти цвета представлены шестнадцатеричными триплетами.
    *   Шестнадцатеричный триплет - шестизначное, трехбайтное шестнадцатеричное число.
    *   Каждый из трех байтов представляет цвет #RRGGBB (красный, зеленый, синий).
    *   Штриховой шестнадцатеричный цвет представлен трехзначным шестнадцатеричным числом #RGB (красный, зеленый, синий).
*   RGB & RGBA Цвета:
    
    *   RGB-цвета - 24-битные (3 байта) цвета, представленные тремя номерами в диапазоне 0-255. (например, rgb (255,255,128)).
    *   Цвет RGBA - 32-битные (4 байта) цвета, представленные тремя цифрами в диапазоне 0-255 и значением альфа, которое управляет непрозрачностью. (например, rgb (255, 255, 128, 0,3)).
*   HSL & HSLA Цвета:
    
    *   Цвет HSL представлен тремя значениями (HUE, Saturation, Lightness).
    *   Цвет HSLA представлен четырьмя значениями (HUE, Saturation, Lightness, Alpha). Альфа контролирует непрозрачность.

#### Больше информации

*   Сайт W3 Schools о том, как форматировать [текст](https://www.w3schools.com/css/css_text.asp) .
*   Сайт W3 Schools по [цветам](https://www.w3schools.com/colors/default.asp) .
*   Цветная собственность на [MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/color) .
*   Документация по [w3.org](https://www.w3.org/wiki/CSS/Properties/color) .