---
title: Flex Property
localeTitle: Свойство Flex
---
## Свойство Flex

Свойство `flex` является сокращением, чтобы указать размер гибкого элемента. `flex-grow` , `flex-shrink` и `flex-basis` могут быть указаны в этом сокращенном виде.

**Это свойство не действует, если элемент не является `flex-item`** . Элемент Flex - это элемент, который является прямым дочерним элементом родителя-контейнера с отображаемым свойством как `flex` или `inline-flex` .

## Синтаксис

Возможные варианты синтаксиса, перечисленные ниже. `flex-grow` и `flex-shrink` принимают целое число как ценность. `flex-basis` принимает единицы стандартного размера, такие как px, em, rem ... и т. д.

```css
flex: <flex-grow> <flex-shrink> <flex-basis>; 
 flex: <flex-basis>; 
 flex: <flex-grow>; 
 flex: <flex-grow> <flex-basis>; 
 flex: <flex-grow> <flex-shrink>; 
```

`flex-basis` определяет размер элемента вдоль главной оси. Внутри контейнера основная ось определяется с помощью `flex-direction` . Основная ось горизонтальна, когда `flex-direction` является `row` . Вертикально, когда направление `flex-direction` - `column` .

`flex-basis: 20px` установил бы начальную ширину элемента в `20px` если направление `flex-direction` - `row` . Такая же `flex-basis` применима к высоте, если `fle-direction` - `column` .

`flex: 20px` автоматически означает `flex-basis: 20px` , так как свойство shorthand имеет только `flex-basis` как свойство, которое может принимать значение с единицей.

`flex: 2` указывает `flex-grow: 2` и элемент будет расти в два раза дольше / выше, чем другие элементы с `flex-grow: 1` .

`flex: 1 2` определяет `flex-grow: 1` и `flex-shrink: 2` . Элемент растет, чтобы занимать пустое пространство пропорционально другим элементам с `flex-grow: 1` но сжимается вдвое меньше, сравнивая другие элементы с `flex-shrink: 1` при нажатии против пространства.

### Больше информации

*   `flex` property reference на [MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/flex)