---
title: Font Family Property
localeTitle: Шрифтовая семья
---
## Шрифтовая семья

Свойство семейства шрифтов является свойством в CSS. Разработчики используют его для изменения семейства шрифтов (или «шрифта») текста веб-сайта или части текста веб-сайта.

Примеры шрифтов включают Arial, Georgia, Times New Roman и многие другие!

Чтобы изменить шрифт части текста, введите селектор определенного текста и пару фигурных скобок. Внутри скобок введите `font-family:` а затем имя шрифта. Если имя шрифта имеет более одного слова, вам нужно использовать либо одно-, либо двойные кавычки. В противном случае котировки не нужны.

```html

<p>This font will be in Times New Roman.</p> 
```

```css
p { 
  font-family: 'Times New Roman'; 
 } 
```

Но многие люди с разными компьютерами просматривают Интернет по всему миру. Это означает, что не каждый будет устанавливать Times New Roman на своих компьютерах. Чтобы помочь этим пользователям, вы должны добавить резервные шрифты. Резервные шрифты - это другие шрифты, которые браузер будет использовать, если первый шрифт недоступен. Добавьте запятую после первого шрифта и добавьте имя первого резервного шрифта. Вы можете использовать более одного резервного шрифта.

```html

<p>This font may or may not be in Lato.</p> 
```

```css
p { 
  font-family: Lato, Helvetica, Georgia; 
  /* Helvetica and Georgia are fallback fonts */ 
 } 
```

Если у пользователя нет установленного Lato, тогда браузер попытается использовать Helvetica. Если у пользователя также нет Helvetica, браузер попытается использовать Грузию. Если у пользователя нет Грузии, браузер будет использовать шрифт, установленный на компьютере пользователя.

Для резервных шрифтов вы можете использовать названные шрифты, такие как Грузия. Вы также можете использовать общие типы, такие как «sans-serif», «serif», «monospace» и другие. Шрифты Sans-serif, такие как Lato, представляют собой шрифты без маленьких строк на концах букв и цифр. Шрифты Serif, такие как Times New Roman, используют небольшие строки на концах букв и цифр. Моношитные шрифты, такие как Консола, имеют буквы и цифры, которые имеют одинаковую ширину.

```html

<p>This font may or may not be in Lato.</p> 
```

```css
p { 
  font-family: Lato, sans-serif, monospace; 
 } 

```