---
title: Font Size Property
localeTitle: Размер шрифта
---
## Размер шрифта

### Определение и использование

Свойство `font-size` используется для установки размера шрифта элемента. Ниже приведен синтаксис по умолчанию для этого свойства.

```css
font-size:medium|xx-small|x-small|small|large|x-large|xx-large|smaller|larger|length|initial|inherit; 
```

Как показано выше, это свойство может принимать несколько значений. Значение по умолчанию - _средний,_ а значения от _xx-small_ до _xx-large_ устанавливают размер шрифта от очень малого до очень большого (например, размеры одежды). _Меньшие_ и _большие_ значения устанавливают размер шрифта меньше размера шрифта родительского элемента и больше размера шрифта родительского элемента, соответственно. Несмотря на наличие вышеупомянутых значений, наиболее распространенным типом используемого значения является единица длины. Единицы длины могут включать: **px** , **%** , **em** , **rem** и **pt** .

### Объясненные единицы длины

#### ПВ

Вы можете использовать блок \* _px_ для установки фиксированного размера шрифта для элемента в пикселях. Один пиксель - одна точка на экране пользователя. Поскольку пиксели обеспечивают фиксированный размер шрифта, размер шрифта не может быть отзывчивым. Это отрицательно, потому что размеры шрифтов могут не отображаться хорошо на разных размерах экрана, и вам придется использовать медиа-запросы, чтобы сделать масштаб шрифта.

**Пример:**

```css
p { 
  font-size: 20px; 
 } 
```

**Результат:** ![Пример 1](https://image.prntscr.com/image/TI_29z3FRO20dJD2Dc7JJA.png)

#### %

Вы можете использовать **процентное%** устройство для установки размера шрифта относительно размера шрифта элемента тела. Значение по умолчанию - 16px, поэтому 100% будет равно 16px. Если размер шрифта тела изменен, размер шрифта любых элементов, содержащихся в теле, который имеет значение в процентах, также изменится. Этот блок позволяет масштабировать шрифт на разных размерах экрана.

**Пример:**

```css
p { 
  font-size: 120%; 
 } 
```

**Результат:** ![Пример два](https://image.prntscr.com/image/P9HTpWbETeyjZhxzf9z-SA.png) Приведенный выше код изменяет размер шрифта до 120% от размера шрифта по умолчанию, равного 16 пикселям.

#### Эм

Другим элементом, который может использоваться для размера шрифта, является единица **em** . Один элемент **em** равен размеру шрифта по умолчанию для ближайшего родительского элемента. Это означает, что 2em будет вдвое больше размера шрифта, а 4em будет в 4 раза больше размера шрифта. Единица **em** становится все более популярной, поскольку она может масштабироваться и мобильна.

**Пример:**

```css
p { 
  font-size: 1.4em; 
 } 
```

**Результат:** ![Пример 3](https://image.prntscr.com/image/AeCJ0TCbRHqOTAFJ9CYNUQ.png) Приведенный выше код устанавливает размер шрифта абзаца в 1,4 раза больше размера шрифта его ближайшего родителя, который является элементом body. Элемент body имеет размер шрифта по умолчанию 16px, поэтому этот абзац будет иметь размер шрифта 1.4 \* 16 = 22.4px.

#### рем

Модуль **rem** очень похож на **em,** но размер шрифта относительно размера шрифта по умолчанию для корневого элемента. Корневым элементом является элемент `<html>` .

**Пример:**

```css
html { 
    font-size: 12px; 
 } 
 p { 
    font-size: 1.4rem; 
 } 
```

**Результат:** ![Пример четыре](https://image.prntscr.com/image/V5bn69UmSPOHSVM5YSAcyw.png) В приведенном выше параграфе имеется размер шрифта 1.4em. На этот раз размер шрифта корневого элемента был изменен на 12 пикселей, поэтому шрифт абзаца теперь 12 \* 1.4 = 16.8px. Модуль **rem** не учитывает шрифт элемента тела, несмотря на то, что он все еще 16px.

#### пт

Конечным элементом для размеров шрифта является значение точки ( **pt** ). Это значение относится к реальным размерам текста. Один **pt** равен 1/72 дюйма на бумаге, поэтому 72pt равно 1 дюйму. Точные значения точны на бумаге, но они могут выглядеть по-разному в разных браузерах. Этот аппарат полезен только тогда, когда вам нужно распечатывать страницы с точным размером шрифта. Блок **pt** не масштабируется.

**Пример:**

```css
p { 
  font-size: 16pt; 
 } 
```

**Результат:** ![Пример пять](https://image.prntscr.com/image/IyOOr_WCT963wa0DoWyoOg.png) Размер шрифта выше 16pt.

Я добавил некоторые ссылки на статьи ниже, если вы хотите больше узнать об этой теме.

#### Дополнительная информация:

*   https://css-tricks.com/css-font-size/
*   https://www.w3schools.com/cssref/pr _font_ font-size.asp
*   https://css-tricks.com/confused-rem-em/
*   https://kyleschaeffer.com/development/css-font-size-em-vs-px-vs-pt-vs/