---
title: Font Variant
localeTitle: Вариант шрифта
---
## Свойство шрифта

Свойство font-variant чаще всего используется для изменения целевого текста на небольшие кепки. Значение по умолчанию - `normal` .

```css
p { 
  font-variant: small-caps; 
 } 
```

Свойство также принимает `all-small-caps` , `petite-caps` , `all-petite-caps` , `titling-caps` и `unicase` ; однако они новы в CSS3 и еще недостаточно хорошо поддерживаются.

Обратите внимание, что если вы используете кепки в разметке HTML, это будет переопределять значение малых кепок, что приведет к регулярным заглавным буквам. Если вы хотите сохранить разметку в верхнем регистре, но переходите к небольшим шапкам с помощью CSS, просто установите `text-transform: lowercase` вместе с объявлением о небольших шапках.

Хотя небольшие колпачки могут добавить дополнительную элегантность для вашей типографии, дизайнеры рекомендуют использовать их только в том случае, если они действительно встроены в шрифт. «Поддельные» маленькие кепки - это компьютерные версии с уменьшенными версиями заглавных букв. «Реальные» маленькие шапки, с другой стороны, рисуются отдельно дизайнером типа и кажутся немного шире и толще, чем «поддельные».

#### Дополнительная информация:

[Дизайн для хакеров](https://designforhackers.com/blog/small-caps/)

[Шрифт-вариант на MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/font-variant)