---
title: Letter Spacing Property
localeTitle: Расстояние между буквами
---
## Расстояние между буквами

Свойство letter-spacing настраивает пространство между всеми буквами в блоке текста. Он также упоминается как «отслеживание» в типографических терминах и в программном обеспечении с расширенными настройками типа. Свойство принимает значения `px` и `em` length, включая отрицательные значения.

```css
.first-example { 
  letter-spacing: 3px; 
 } 
 .second-example { 
  letter-spacing: -1px; 
 } 
 .third-example { 
  letter-spacing: 0.5em; 
 } 
```

![результат CSS](https://github.com/kaithrendyle/guide-photos/blob/master/letter-spacing.png)

В общем, хорошей практикой является использование относительных единиц ( `em` ), поскольку интервал всегда будет относиться к указанному вами размеру шрифта.

При настройке расстояния между буквами важно учитывать разборчивость. Если буквы слишком близко друг к другу, они могут казаться тесными и трудночитаемыми. С другой стороны, если буквы слишком далеки друг от друга, они могут не читать как слово, а вместо этого как отдельные буквы. Это может также повлиять на то, как читатели экрана читают текст вслух людям с низким зрением.

Обычно буквы в нижнем регистре обычно не требуют изменения расстояния между буквами. Вы можете найти необходимость в настройках, если вы используете разделы прописных букв, если интервал выглядит слишком туго.

#### Дополнительная информация: