---
title: Margin Property
localeTitle: Маржинальная собственность
---
## Маржинальная собственность

Свойство margin - это пространство вокруг элемента, а не padding, которое является пространством внутри элемента. Поля прозрачны и являются самым внешним элементом в модели Box (см. Диаграмму ниже).

![Диаграмма модели коробки](https://css-tricks.com/wp-content/csstricks-uploads/thebox.png)

Источник: https://css-tricks.com/the-css-box-model/

### Настройка маржи

Существует несколько способов задания поля элемента.

Простой способ ...

```css
  margin: 10px; 
```

Это положит 10 пикселей пространства вокруг элемента.

Вы также можете поместить различное количество места на каждой стороне элемента. Например:

```css
  margin-top: 10px; 
  margin-bottom: 15px; 
  margin-left: 20px; 
  margin-right: 25px; 
```

Однако при определении разных сторон элемента можно использовать стенографию. Он начинается сверху и идет по часовой стрелке вокруг элемента (сверху, справа, внизу, слева). Например, код будет записан в shorhand следующим образом:

```css
  margin: 10px 25px 15px 25px; 
```

Кроме того, если нижнее и верхнее поля одинаковы, а левое и правое поля одинаковы, их можно записать так:

```css
  margin: 10px 20px; 
```

где верхний и нижний поля составляют 10 пикселей, а левое и правое поля - 20 пикселей.

### Другие значения свойств

auto - браузер вычисляет поля.

initial - установить свойство в его начальное значение

inherit - элемент наследует маржу от своего родительского элемента

### Измерение пространства

Так же, как есть несколько способов настройки поля, есть также несколько способов измерения поля.

px - Измерение в пикселях, стандартная единица измерения пространства экрана.

% - Процент экрана. Это заставит элемент сжиматься и расти с помощью браузера и является одним из рекомендуемых единиц измерения для гибкого веб-дизайна.

em - размер относительно размера шрифта текущего элемента.

единица измерения размера относительно размера шрифта корневого элемента страницы.

[Вот](https://www.w3schools.com/CSSref/css_units.asp) руководство по единицам CSS.

[Это руководство по быстрому стилю поможет вам принять ваш запрос на тягу](https://github.com/freecodecamp/guides/blob/master/README.md) .

#### Дополнительная информация:

*   [W3 Школы](https://www.w3schools.com/CSSref/pr_margin.asp)
*   [MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/margin)
*   [Трюки CSS](https://css-tricks.com/almanac/properties/m/margin/)