---
title: Class
localeTitle: Класс
---
## Класс

Селектор класса «CSS» используется для применения одного и того же стиля к нескольким элементам на странице. Отличный способ подумать об этом будет похож на план автомобиля или здания. План позволит вам построить несколько автомобилей или несколько зданий таким же образом после проектирования фактической компоновки один раз.

### Случаи применения

В отличие от имен классов «ID» CSS не уникальны. Поэтому вам будет полезно использовать «класс» несколько раз, если вы хотите, чтобы эти элементы применялись к тому же стилю. На самом деле, это будет отличным временем для вас, чтобы использовать «класс». Если вы хотите, чтобы три элемента «div» в вашем HTML имели синий фон, вы могли бы использовать класс один раз в своем CSS, как показано в примере ниже.
```
<html> 
 <style> 
  .blueBg { 
    background-color: blue; 
  } 
 </style> 
  <body> 
    <div class="blueBg"></div> 
    <div class="blueBg"></div> 
    <div class="blueBg"></div> 
  </body> 
 </html> 
```

#### Дополнительная информация:

Если вы хотите узнать больше о селекторе «класс» CSS, перейдите на [эту страницу](https://css-tricks.com/the-difference-between-id-and-class/)