---
title: Pseudo
localeTitle: Псевдо
---
# Псевдоселекторы

Псевдоселекторами предусмотрена возможность целевых элементов с использованием псевдоклассов или псевдоэлементов.

## Структурные псевдоклассы

Структурные псевдо-классы предлагают способ нацеливания элементов на основе их положения.

Класс | Описание --------- | ------------ `:root` | Корень документа. В контексте HTML-документов это будет `html` тег вверху. Это может означать разные элементы в других документах, таких как XML или SVG. `:only-child` | Элемент, который является единственным дочерним элементом его родительского элемента. `:first-child` | Первый ребенок родителя. `:last-child` | Последний дочерний элемент родительского элемента. `:nth-child(n)` | n-й дочерний элемент родителя. `:nth-last-child(n)` | n-й ребенок от последнего ребенка. Реверс `:nth-child` . `:only-of-type` | Единственный элемент типа внутри своих братьев и сестер с другими типами. `:first-of-type` | Первый элемент типа среди его братьев и сестер. `:last-of-type` | Последний элемент типа среди его братьев и сестер. `:nth-of-type(n)` | n-й брат одного и того же типа. `:nth-last-of-type(n)` | n-й брат одного и того же типа из последнего. Реверс `:nth-of-type` . `:empty` | Элемент без каких-либо дочерних элементов.

## Пользовательские псевдоязычные пользовательские классы

Псевдо-классы состояния пользовательского интерфейса предлагают способ нацеливания элементов на основе их текущего состояния.

Класс | Описание --------- | ------------ `:link` | Непредвиденные элементы ссылок. `:visited` | Уже посещенная ссылка. `:hover` | Элемент, над которым курсор мыши висит. `:active` | Элемент, на который был нажат указатель мыши, но еще не выпущен. `:focus` | Элемент, который имеет фокус. Важно для доступности, например, при использовании клавиши `tab` для навигации. `:enabled` | Элемент, находящийся в разрешенном состоянии. `:disabled` | Элемент, который был отключен. `:checked` | Выбранный флажок или Радио.

## Псевдоэлементы

С другой стороны, псевдоэлементы - это динамически генерируемые элементы или элементы в специальном месте.

Селектор | Описание --------- | ------------ `::first-line` | Первая строка элемента, обычно это контейнер или абзац. `::first-letter` | Буква элемента. Широко используется для укладки капюшона. `::before` | Динамический элемент, созданный с собственным содержимым до фактического элемента. `::after` | Динамический элемент, созданный с собственным содержимым после фактического элемента.

## Дополнительная информация:

Дополнительную информацию можно найти в следующих ссылках.

*   [Официальная спецификация CSS3 Selector](https://www.w3.org/TR/css3-selectors/#structural-pseudos)
*   [Страница сети разработчика Mozilla на селекторах](https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Selectors)